% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_point.R
\name{gg_point_facet}
\alias{gg_point_facet}
\title{Point ggplot that is facetted.}
\usage{
gg_point_facet(
  data,
  x_var,
  y_var,
  facet_var,
  text_var = NULL,
  pal = pal_viridis_reorder(1),
  alpha_point = 1,
  size_point = 1.5,
  title = NULL,
  title_wrap = 80,
  subtitle = NULL,
  subtitle_wrap = 80,
  x_balance = FALSE,
  x_breaks_n = 2,
  x_expand = NULL,
  x_jitter = 0,
  x_labels = NULL,
  x_rev = FALSE,
  x_title = NULL,
  x_title_wrap = 50,
  x_zero = FALSE,
  x_zero_line = NULL,
  y_balance = FALSE,
  y_breaks_n = 3,
  y_expand = c(0, 0),
  y_jitter = 0,
  y_labels = scales::label_comma(),
  y_title = NULL,
  y_title_wrap = 50,
  y_zero = FALSE,
  y_zero_line = NULL,
  facet_labels = snakecase::to_sentence_case,
  facet_na_rm = FALSE,
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_rev = FALSE,
  facet_scales = "fixed",
  caption = NULL,
  caption_wrap = 80,
  theme = gg_theme(gridlines_h = TRUE, gridlines_v = TRUE)
)
}
\arguments{
\item{data}{An ungrouped summarised tibble or dataframe in a structure to be plotted untransformed. Required input.}

\item{x_var}{Unquoted variable to be on the x scale (i.e. character, factor, logical, numeric, date or POSIXt). Required input.}

\item{y_var}{Unquoted numeric variable to be on the y scale. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{text_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot, tooltip = "text"). Defaults to NULL.}

\item{pal}{Character vector of hex codes.}

\item{alpha_point}{The opacity of the points.}

\item{size_point}{Size of points. Defaults to 1.5.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 100.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 100.}

\item{x_balance}{For a numeric x variable, add balance to the x scale so that zero is in the centre. Defaults to FALSE.}

\item{x_breaks_n}{For a numeric or date x variable, the desired number of intervals on the x scale, as calculated by the pretty algorithm. Defaults to 2.}

\item{x_expand}{A vector of range expansion constants used to add padding to the x scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{x_jitter}{Amount of horizontal jitter to be added in positive and negative directions. Defaults to 0. See ggplot2::position_jitter for further information.}

\item{x_labels}{A function or named vector to modify x scale labels. Use function(x) x to keep labels untransformed.}

\item{x_rev}{For a categorical x variable, TRUE or FALSE of whether the x variable variable is reversed. Defaults to FALSE.}

\item{x_title}{X scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{x_zero}{For a numeric x variable, TRUE or FALSE of whether the minimum of the x scale is zero. Defaults to FALSE.}

\item{x_zero_line}{For a numeric x variable, TRUE or FALSE of whether to add a zero reference line to the x scale. Defaults to TRUE if there are positive and negative values in x_var. Otherwise defaults to FALSE.}

\item{y_balance}{For a numeric y variable, add balance to the y scale so that zero is in the centre of the y scale.}

\item{y_breaks_n}{For a numeric or date x variable, the desired number of intervals on the x scale, as calculated by the pretty algorithm. Defaults to 4.}

\item{y_expand}{A vector of range expansion constants used to add padding to the y scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{y_jitter}{Amount of vertical jitter to be added in positive and negative directions. Defaults to 0.See ggplot2::position_jitter for further information.}

\item{y_labels}{A function or named vector to modify y scale labels. Use function(x) x to keep labels untransformed.}

\item{y_title}{y scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{y_zero}{For a numeric y variable, TRUE or FALSE of whether the minimum of the y scale is zero. Defaults to TRUE.}

\item{y_zero_line}{For a numeric y variable, TRUE or FALSE whether to add a zero reference line to the y scale. Defaults to TRUE if there are positive and negative values in y_var. Otherwise defaults to FALSE.}

\item{facet_labels}{A function or named vector to modify facet scale labels. Defaults to converting labels to sentence case. Use function(x) x to keep labels untransformed.}

\item{facet_na_rm}{TRUE or FALSE of whether to include facet_var NA values. Defaults to FALSE.}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{facet_rev}{TRUE or FALSE of whether the facet variable variable is reversed. Defaults to FALSE.}

\item{facet_scales}{Whether facet_scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{theme}{A ggplot2 theme.}
}
\value{
A ggplot object.
}
\description{
Point ggplot that is facetted, but not coloured.
}
\examples{
library(simplevis)
library(palmerpenguins)

gg_point_facet(penguins, 
               x_var = bill_length_mm, 
               y_var = body_mass_g, 
               facet_var = species)

}
