% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{sim_standardized}
\alias{sim_standardized}
\title{Generates simulated data with standardized parameters.}
\usage{
sim_standardized(m, n = 1000, observed = TRUE, latent = TRUE,
  errors = TRUE, factor_scores = FALSE, composites = FALSE,
  matrices = FALSE)
}
\arguments{
\item{m}{Structural model represented by lavaan syntax}

\item{n}{Number of simulated cases}

\item{observed}{Include observed variables}

\item{latent}{Include latent variables}

\item{errors}{Include observed error and latent disturbances variables}

\item{factor_scores}{Include factor score variables}

\item{composites}{Include composite variables}

\item{matrices}{Include matrices as attribute of tibble}
}
\value{
tibble with standardized data
}
\description{
This function takes a lavaan model with standardized parameters and simulates latent scores, errors, disturbances, and observed scores.
}
\details{
This function supports the `~` operator for regressions, the `~~` for covariances (but not variances), and the `=~` latent variable loadings. It does not support intercepts (e.g,. `y ~ 1`), thresholds, scaling factors, formative factors, or equality constraints.
}
\examples{
library(simstandard)
# Lavaan model
m = "Latent_1 =~ 0.8 * Ob_1 + 0.7 * Ob_2 + 0.4 * Ob_3"

# simulate 10 cases
sim_standardized(m, n = 10)
}
