% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/process_to_wv.cpp, src/process_to_wv.h
\name{arma_to_wv_app}
\alias{arma_to_wv_app}
\title{ARMA process to WV Approximation}
\usage{
arma_to_wv_app(ar, ma, sigma2, tau, alpha = 0.9999)
}
\arguments{
\item{ar}{A \code{vec} containing the coefficients of the AR process}

\item{ma}{A \code{vec} containing the coefficients of the MA process}

\item{sigma2}{A \code{double} containing the residual variance}

\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}

\item{alpha}{A \code{double} indicating the cutoff.}
}
\value{
A \code{vec} containing the wavelet variance of the ARMA process.
}
\description{
This function computes the (haar) WV of an ARMA process
}
\details{
This function provides an approximation to the \code{\link{arma_to_wv}} as computation times
were previously a concern. However, this is no longer the case and, thus, this has been left
in for the curious soul to discover...
}
\section{Process Haar Wavelet Variance Formula}{

The Autoregressive Order \eqn{p} and Moving Average Order \eqn{q} (ARMA(\eqn{p},\eqn{q})) process has a Haar Wavelet Variance given by:
\deqn{\frac{{{\tau _j}\left[ {1 - \rho \left( {\frac{{{\tau _j}}}{2}} \right)} \right] + 2\sum\limits_{i = 1}^{\frac{{{\tau _j}}}{2} - 1} {i\left[ {2\rho \left( {\frac{{{\tau _j}}}{2} - i} \right) - \rho \left( i \right) - \rho \left( {{\tau _j} - i} \right)} \right]} }}{{\tau _j^2}}\sigma _X^2}{(tau[j]*(1-rho(tau[j]/2)) + 2*sum(i*(2*rho(tau[j]/2 - i) + rho(i) - rho(tau[j] - i))))/tau[j]^2 * sigma[x]^2}
 where \eqn{\sigma _X^2}{sigma[X]^2} is given by the variance of the ARMA process. 
Furthermore, this assumes that stationarity has been achieved as it directly
}

\keyword{internal}
