% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws-class.R
\docType{class}
\name{Draws-class}
\alias{Draws-class}
\title{An S4 class representing the random draws from a Model object.}
\description{
An object of class Draws represents the randomly drawn simulated data that is
generated when \code{\link{simulate_from_model}} is called on an object of
class Model.  In particular, it contains a named list of \code{nsim}
simulated draws from a model object.  The Model object's \code{simulate}
function populates this list.
}
\details{
This class inherits from the \code{\linkS4class{Component}} class.
}
\section{Slots}{

\describe{
\item{\code{name}}{a short name identifier.  Must be alphanumeric. Should use
the name of the Model object that generated it.}

\item{\code{label}}{a longer, human readable label that indicates what has been
randomly drawn.}

\item{\code{draws}}{a list with \code{nsim} elements as created by calling
the \code{simulate} function of a Model object. This is a named
list with each element labeled as \code{ri.j} where \code{i} is the
\code{index} and \code{j} ranges from \code{1} to \code{nsim}.  The
names are assigned by \code{\link{simulate_from_model}}.}

\item{\code{index}}{an integer-valued numeric that indicates which block of random
draws this is}
}}

