% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-class.R
\docType{class}
\name{Model-class}
\alias{Model-class}
\title{An S4 class representing the model component of the simulator.}
\description{
An object of class Model specifies the statistical model.  In particular,
all parameters are specified in addition to a function called \code{simulate}
that allows one to draw random samples from this model.
}
\details{
To get parameters stored in a \code{Model} object, a shortcut for
\code{my_model@params$my_parameter} is \code{my_model$my_parameter}.

This class inherits from the \code{\linkS4class{Component}} class.
}
\section{Slots}{

\describe{
\item{\code{name}}{a short name identifier.  Must be alphanumeric (though -, _, and
/ are allowed as long as they are not at the start or end of name.}

\item{\code{label}}{a longer, human readable label that can have other characters
such as spaces, hyphens, etc.}

\item{\code{params}}{a list that contains the Model object's parameters}

\item{\code{simulate}}{a function that has arguments \code{nsim} and names
matching elements within \code{names(params)}. It returns a list of
length nsim, where each element of the list represents a random draw
from the \code{Model} object.}
}}

