% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/untangle.R
\name{untangle}
\alias{untangle}
\title{Split an R script by functions}
\usage{
untangle(text = NULL, file = "", dir.out = NULL, keep.body = TRUE)
}
\arguments{
\item{text}{character, vector of R commands, Default: NULL}

\item{file}{character, path to R file, Default: ''}

\item{dir.out}{character, path to save new R files, Default: NULL}

\item{keep.body}{boolean, if TRUE all non-funcitons will be saved to body.R, Default: TRUE}
}
\value{
list of seperate functions
}
\description{
Split a R script with multiple functions into multiple single function R files.
}
\details{
body.R is written to the working directory and not dir.out .
}
\examples{
\dontrun{
txt <- "#some comment
#' @import utils
yy <- function(a=4){
 utils::head(runif(10),a)
 # a comment
}

v <- 20

#another comment
#' @import utils
zz <- function(v=10,a=3){
 utils::head(runif(v),pmin(a,v))
}

zz(v)

"
untangle(txt,dir.out = 'test')

}
}
\author{
Jonathan Sidi
}
