% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_simulation.R
\name{callJuliaStochasticSimulation}
\alias{callJuliaStochasticSimulation}
\title{Calls the Julia simulation function.}
\usage{
callJuliaStochasticSimulation(stochmodel, QTLeffects, InitVar, genes,
  simtime, modelname = "MySimulation", ntrials, nepochs, simalgorithm,
  ev = getJuliaEvaluator())
}
\arguments{
\item{stochmodel}{A Julia proxy object to retrieve the stochastic system in the Julia evaluator.}

\item{QTLeffects}{The list of QTL effects coefficients of the in silico individual to be simulated (see \code{\link{createIndividual}}).}

\item{InitVar}{The list of initial abundance variation coefficients of the in silico individual to be simulated (see \code{\link{createIndividual}}).}

\item{genes}{The data-frame of genes in the system.}

\item{simtime}{Numeric. The amount of time to simulate the model (in seconds).}

\item{modelname}{String. The name of the model. Default value "MySimulation".}

\item{ntrials}{Integer. The number of times the simulation must be replicated.}

\item{nepochs}{Integer. The number of times to record the state of the system during the simulation.}

\item{simalgorithm}{String. The name of the simulation algorithm to use in the Julia function \code{simulate} from the module \code{BioSimulator}.
Can be one of "Direct", "FirstReaction", "NextReaction", "OptimizedDirect", "TauLeaping", "StepAnticipation".}

\item{ev}{A Julia evaluator. If none provided select the current evaluator or create one if no evaluator exists.}
}
\value{
The result of the simulation (a data-frame).
}
\description{
Calls the Julia function for simulating a stochastic system. Should not be used by itself (this function is called by the wrapper functions \link{simulateInSilicoSystem} and \link{simulateParallelInSilicoSystem}).
}
