% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sitar.R
\name{plot.sitar}
\alias{plot.sitar}
\alias{lines.sitar}
\alias{plot_d}
\alias{plot_v}
\alias{plot_D}
\alias{plot_V}
\alias{plot_u}
\alias{plot_a}
\alias{plot_c}
\title{Plot SITAR model}
\usage{
\method{plot}{sitar}(
  x,
  opt = "dv",
  labels,
  apv = FALSE,
  xfun = identity,
  yfun = identity,
  subset = NULL,
  ns = 101,
  abc = NULL,
  trim = 0,
  add = FALSE,
  nlme = FALSE,
  returndata = FALSE,
  ...,
  xlab = NULL,
  ylab = NULL,
  vlab = NULL,
  xlim = c(NA, NA),
  ylim = c(NA, NA),
  vlim = c(NA, NA),
  legend = list(x = "topleft", inset = 0.04, bty = "o")
)

\method{lines}{sitar}(x, ...)

plot_d(x, ...)

plot_v(x, ...)

plot_D(x, ...)

plot_V(x, ...)

plot_u(x, ...)

plot_a(x, ...)

plot_c(x, ...)
}
\arguments{
\item{x}{object of class \code{sitar}.}

\item{opt}{character string containing a subset of letters corresponding to
the options: 'd' for fitted Distance curve, 'v' for fitted Velocity curve,
'c' for fitted Crosssectional distance curve, 'D' for individual fitted
Distance curves, 'V' for individual fitted Velocity curves, 'u' for
Unadjusted individual growth curves, and 'a' for Adjusted individual growth
curves. Options 'dvcDV' give spline curves, while 'ua' give data curves made
up as line segments. If both distance and velocity curves are specified, the
axis for the velocity curve appears on the right side of the plot (y2), and
a legend identifying the distance and velocity curves is provided.}

\item{labels}{optional character vector containing plot labels for \code{x},
\code{y} and \code{y} velocity from the original SITAR model. The three
elements can alternatively be provided via parameters
\code{xlab}, \code{ylab} and \code{vlab}. The latter take precedence.
Default labels are the names of \code{x} and \code{y}, and
"\code{y} velocity", suitably adjusted to reflect any back-transformation
via \code{xfun} and \code{yfun}.}

\item{apv}{optional logical specifying whether or not to calculate the age
at peak velocity from the velocity curve. If TRUE, age at peak velocity is
calculated as the age when the second derivative of the fitted curve changes
sign (after applying \code{xfun} and/or \code{yfun}). Age at peak velocity
is marked in the plot with a vertical dotted line, and its value, along with
peak velocity, is printed and returned. NB their standard errors can be
obtained using the bootstrap with the function \code{apv_se}.}

\item{xfun}{optional function to be applied to the x variable prior to
plotting (default identity, see Details).}

\item{yfun}{optional function to be applied to the y variable prior to
plotting (default identity, see Details).}

\item{subset}{optional logical vector of length \code{x} defining a subset
of \code{data} rows to be plotted, for \code{x} and \code{data} in the
original \code{sitar} call.}

\item{ns}{scalar defining the number of points for spline curves
(default 101).}

\item{abc}{vector of named values of random effects a, b and c used to
define an individual growth curve, e.g. abc=c(a=1, c=-0.1). Alternatively a
single character string defining an \code{id} level whose random effect
values are used. If \code{abc} is set, \code{level} is ignored. If
\code{abc} is NULL (default), or if a, b or c values are missing, values of
zero are assumed.}

\item{trim}{number (default 0) of long line segments to be excluded from plot
with option 'u' or 'a'. See Details.}

\item{add}{optional logical defining if the plot is pre-existing (TRUE) or
new (FALSE). TRUE is equivalent to using \code{lines}.}

\item{nlme}{optional logical which set TRUE plots the model as an
\code{nlme} object, using \code{plot.nlme} arguments.}

\item{returndata}{logical defining whether to plot the data (default FALSE)
or just return the data for plotting (TRUE). See Value.}

\item{\dots}{Further graphical parameters (see \code{par}) may also be
supplied as arguments, e.g. line
type \code{lty}, line width \code{lwd}, and colour \code{col}. For the
velocity (y2) plot \code{y2par} can be used (see Details).}

\item{xlab}{optional label for x axis}

\item{ylab}{optional label for y axis}

\item{vlab}{optional label for v axis (velocity)}

\item{xlim}{optional x axis limits}

\item{ylim}{optional y axis limits}

\item{vlim}{optional v axis limits}

\item{legend}{optional list of arguments for legend with distance-velocity plots}
}
\value{
If \code{returndata} is FALSE returns invisibly a list of (up to) three objects:
\item{usr}{value of \code{par('usr')} for the main plot.}
\item{usr2}{the value of \code{par('usr')} for the velocity (y2) plot.}
\item{apv}{if argument \code{apv} is TRUE a named list giving the age at
peak velocity (apv) and peak velocity (pv) from the fitted velocity curve,
either overall or (with options D or V, invisibly) for all subjects.}
If \code{returndata} is TRUE (which it is with the helper functions) returns
invisibly either a tibble or named list of tibbles,
containing the data to be plotted. The helper functions each return a tibble.
The variable names are '.x', '.y' and
(for curves grouped by subject) '.id'. Note that '.x' and '.y' are returned
after applying \code{xfun} and \code{yfun}. Hence if for example \code{x = log(age)}
in the SITAR call then '.x' corresponds by default to \code{age}.
}
\description{
\code{plot} and \code{lines} methods for objects of class \code{sitar},
providing various flavours of plot of the fitted growth curves. Also helper
functions to return the data for plotting, e.g. with \code{ggplot2}.
}
\details{
For options involving both distance curves (options 'dcDua') and velocity curves
(options 'vV') the velocity curve plot (with right axis) can be annotated with
\code{par} parameters given as a named list called \code{y2par}.
To suppress the legend that comes with it set \code{legend = NULL}.

The transformations \code{xfun} and \code{yfun} are applied to the x and y
variables after inverting any transformations applied in the original SITAR
call. So for example if \code{y = log(height)} in the SITAR call, then \code{yfun}
is applied to \code{height}. Thus the default \code{yfun = identity} has the effect of
inverting the transformation. This is achieved by setting
\code{yfun = yfun(ifun(x$call.sitar$y))}.
For no transformation set \code{yfun = NULL}.

The helper functions \code{plot_d}, \code{plot_v}, \code{plot_D},
\code{plot_V}, \code{plot_u}, \code{plot_a} and \code{plot_c}
correspond to the seven plot \code{option}s defined by their last letter,
and return the data for plotting as a \code{tibble}, e.g. for use with \code{ggplot2}.

The \code{trim} option allows unsightly long line segments to be omitted
from plots with options 'a' or 'u'. It ranks the line segments on the basis
of the age gap (dx) and the distance of the midpoint of the line from the
mean curve (dy) using the formula \code{abs(dx)/mad(dx) + abs(dy)/mad(dy)}
and omits those with the largest values.
}
\examples{

## fit sitar model
m1 <- sitar(x=age, y=height, id=id, data=heights, df=4)

## draw fitted distance and velocity curves
## with velocity curve in blue
## adding age at peak velocity (apv)
plot(m1, y2par=list(col='blue'), apv=TRUE)

## bootstrap standard errors for apv and pv
\dontrun{
res <- apv_se(m1, nboot=20, plot=TRUE)
}
## draw individually coloured growth curves adjusted for random effects
## using same x-axis limits as for previous plot
plot(m1, opt='a', col=id, xlim=xaxsd())

## add mean curve in red
lines(m1, opt='d', col='red', lwd=2)

## add mean curve for a, b, c = -1 SD
lines(m1, opt='d', lwd=2, abc=-sqrt(diag(getVarCov(m1))))

## use subset to plot mean curves by group
## compare curves for early versus late menarche
heights <- within(sitar::heights, {
  men <- abs(men)
    late <- factor(men > median(men))
  })
# fit model where size and timing differ by early vs late menarche
object <- sitar(log(age), height, id, heights, 5,
  a.formula = ~late, b.formula = ~late)
## early group
plot(object, subset = late == FALSE, col = 4, lwd = 3,
  y2par = list(col = 4, lwd = 2), ylim = range(heights$height))
## late group
lines(object, subset = late == TRUE, col = 2, lwd = 3,
  y2par = list(col = 2, lwd = 2))
## add legend
legend('right', paste(c('early', 'late'), 'menarche'),
  lty = 1, col = c(4, 2), inset = 0.04)

## draw fitted height distance curves coloured by subject, using ggplot
\dontrun{
require(ggplot2)
ggplot(plot_D(m1), aes(.x, .y, colour=.id)) +
labs(x='age', y='height') +
geom_line(show.legend=FALSE)
}
}
\seealso{
\code{\link{mplot}},
\code{\link{plotclean}}, \code{\link{ifun}}, \code{\link{apv_se}}
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
\keyword{aplot}
