% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_view.R
\name{sits_view}
\alias{sits_view}
\alias{sits_view.sits}
\alias{sits_view.data.frame}
\alias{sits_view.som_map}
\alias{sits_view.raster_cube}
\alias{sits_view.vector_cube}
\alias{sits_view.uncertainty_cube}
\alias{sits_view.class_cube}
\alias{sits_view.probs_cube}
\alias{sits_view.default}
\title{View data cubes and samples in leaflet}
\usage{
sits_view(x, ...)

\method{sits_view}{sits}(x, ..., legend = NULL, palette = "Harmonic")

\method{sits_view}{data.frame}(x, ..., legend = NULL, palette = "Harmonic")

\method{sits_view}{som_map}(x, ..., id_neurons, legend = NULL, palette = "Harmonic")

\method{sits_view}{raster_cube}(
  x,
  ...,
  band = NULL,
  red = NULL,
  green = NULL,
  blue = NULL,
  tiles = x[["tile"]],
  dates = NULL,
  class_cube = NULL,
  legend = NULL,
  palette = "RdYlGn",
  opacity = 0.7
)

\method{sits_view}{vector_cube}(
  x,
  ...,
  band = NULL,
  red = NULL,
  green = NULL,
  blue = NULL,
  tiles = x[["tile"]],
  dates = NULL,
  class_cube = NULL,
  legend = NULL,
  palette = "RdYlGn",
  opacity = 0.7,
  seg_color = "black",
  line_width = 1
)

\method{sits_view}{uncertainty_cube}(
  x,
  ...,
  tiles = x[["tile"]],
  class_cube = NULL,
  legend = NULL,
  palette = "Blues",
  opacity = 0.7
)

\method{sits_view}{class_cube}(
  x,
  ...,
  tiles = x[["tile"]],
  legend = NULL,
  palette = "Spectral",
  opacity = 0.8
)

\method{sits_view}{probs_cube}(
  x,
  ...,
  tiles = x[["tile"]],
  class_cube = NULL,
  legend = NULL,
  opacity = 0.7,
  palette = "YlGnBu"
)

\method{sits_view}{default}(x, ...)
}
\arguments{
\item{x}{Object of class "sits", "data.frame", "som_map",
"raster_cube" or "classified image".}

\item{...}{Further specifications for \link{sits_view}.}

\item{legend}{Named vector that associates labels to colors.}

\item{palette}{Color palette (if colors not in legend nor
in sits default colors)}

\item{id_neurons}{Neurons from the SOM map to be shown.}

\item{band}{For plotting grey images.}

\item{red}{Band for red color.}

\item{green}{Band for green color.}

\item{blue}{Band for blue color.}

\item{tiles}{Tiles to be plotted (in case of a multi-tile cube).}

\item{dates}{Dates to be plotted.}

\item{class_cube}{Classified cube to be overlayed on top on image.}

\item{opacity}{Opacity of segment fill or class cube}

\item{seg_color}{Color for segment boundaries}

\item{line_width}{Line width for segments (in pixels)}
}
\value{
A leaflet object containing either samples or
                      data cubes embedded in a global map that can
                      be visualized directly in an RStudio viewer.
}
\description{
Uses leaflet to visualize time series, raster cube and
classified images
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # view samples
    sits_view(cerrado_2classes)
    # create a local data cube
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    modis_cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir
    )
    # view the data cube
    sits_view(modis_cube,
        band = "NDVI"
    )
    # train a model
    rf_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # classify the cube
    modis_probs <- sits_classify(
        data = modis_cube,
        ml_model = rf_model,
        output_dir = tempdir()
    )
    # generate a map
    modis_label <- sits_label_classification(
        modis_probs,
        output_dir = tempdir()
    )
    # view the classified map
    sits_view(modis_label)
    # view the classified map with the B/W image
    sits_view(modis_cube,
        band = "NDVI",
        class_cube = modis_label,
        dates = sits_timeline(modis_cube)[[1]]
    )
    # view the classified map with the RGB image
    sits_view(modis_cube,
        red = "NDVI", green = "NDVI", blue = "NDVI",
        class_cube = modis_label,
        dates = sits_timeline(modis_cube)[[1]]
    )
    # create an uncertainty cube
    modis_uncert <- sits_uncertainty(
        cube = modis_probs,
        output_dir = tempdir()
    )
    # view the uncertainty cube
    sits_view(modis_uncert)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
