% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_histogram.R
\name{hist.raster_cube}
\alias{hist.raster_cube}
\title{histogram of data cubes}
\usage{
\method{hist}{raster_cube}(x, ..., tile = x[["tile"]][[1]], date = NULL, band = NULL, size = 10000)
}
\arguments{
\item{x}{Object of classes "raster_cube".}

\item{...}{Further specifications for \link{summary}.}

\item{tile}{Tile to be shown}

\item{date}{Date to be shown}

\item{band}{Band to be shown}

\item{size}{Number of cells to be sampled}
}
\value{
A histogram of one band of  data cube.
}
\description{
This is a generic function. Parameters depend on the specific
type of input.
}
\examples{
if (sits_run_examples()) {
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    hist(cube)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
