% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking_data.R
\name{agrupar_edad_sex}
\alias{agrupar_edad_sex}
\title{Agrupar por edades, sexo y casos}
\usage{
agrupar_edad_sex(
  data_event,
  col_edad = "edad",
  col_sex = "sexo",
  porcentaje = TRUE,
  interval_edad = 10
)
}
\arguments{
\item{data_event}{Un `data.frame` que contiene los datos de la enfermedad
o evento.}

\item{col_edad}{Un `character` (cadena de caracteres) con el nombre de la
columna que contiene las edades en los datos de la enfermedad o evento;
su valor por defecto es `"edad"`.}

\item{col_sex}{Un `character` (cadena de caracteres) con el nombre de la
columna que contiene el sexo en los datos de la enfermedad o evento;
su valor por defecto es `"sexo`.}

\item{porcentaje}{Un `logical` (TRUE o FALSE) que indica si se debe
agregar una columna con el porcentaje de casos; su valor por
defecto es `TRUE`.}

\item{interval_edad}{Un `numeric` (numérico) que contiene el intervalo del
rango de edades; su valor por defecto es `10`.}
}
\value{
Un `data.frame` con los datos de enfermedades agrupados
por edades, sexo y número de casos.
}
\description{
Función que agrupa los datos de una enfermedad o evento por
edades, sexo y número de casos.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
agrupar_edad_sex(
  data_event = data_limpia,
  col_edad = "edad",
  col_sex = "sexo",
  porcentaje = TRUE
)
}
