% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphMat-main.R
\name{plot.classify}
\alias{plot.classify}
\title{Plot method for classify class}
\usage{
\method{plot}{classify}(x, xlab = "X", ylab = "Y", col = c(1, 2),
  pch = c(4, 5), cex = c(1, 1), lty_lines = c(1, 1),
  lwd_lines = c(1, 1), legendPlot = TRUE, cex_label = 0.8, ...)
}
\arguments{
\item{x}{an object of class 'classify' with the allometric variables ("X", "Y") and classification of maturity (juveniles = 0, adults = 1).}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{col}{the colors for juveniles and adults group.}

\item{pch}{the character indicating the type of plotting.}

\item{cex}{character expansion in the regression.}

\item{lty_lines}{the line type in the regression.}

\item{lwd_lines}{the line width in the regression.}

\item{legendPlot}{legend in the plot (FALSE or TRUE).}

\item{cex_label}{size of the legendPlot}

\item{\dots}{Additional arguments to the plot method.}
}
\description{
Plot method for classify class
}
\examples{
data(crabdata)

classify_data = classify_mature(crabdata, varNames = c("carapace_width", "chela_heigth"),
varSex = "sex_category", selectSex = NULL, method = "ld")

## Showing different plots
plot(classify_data, xlab = "X")

plot(classify_data, xlab = "X", ylab = "Y", col = c(1, 2), pch = c(4, 5), cex = c(1, 3))

plot(classify_data, xlab = "Carapace width (mm.)", ylab = "Y", col = c(1, 2),
pch = c(4, 5), cex = c(1, 3), lwd_lines = c(1, 3))

plot(classify_data, xlab = "Carapace width (mm.)", ylab = "Y", col = c(1, 2),
pch = c(4, 5), cex = c(1, 3), lwd_lines = c(1, 3), main = "Classification")
}
