% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjTabLinReg.R
\name{sjt.lmer}
\alias{sjt.lmer}
\title{Show linear mixed effects models as HTML table}
\usage{
sjt.lmer(..., file = NULL, labelPredictors = NULL,
  labelDependentVariables = NULL, stringPredictors = "Predictors",
  stringDependentVariables = "Dependent Variables", stringModel = "Model",
  showHeaderStrings = FALSE, stringIntercept = "(Intercept)",
  stringObservations = "Observations", stringB = "B",
  stringSB = "std. Beta", stringCI = "CI", stringSE = "std. Error",
  stringP = "p", showEst = TRUE, showConfInt = TRUE,
  showStdBeta = FALSE, showStdError = FALSE, digits.est = 2,
  digits.p = 3, digits.ci = 2, digits.se = 2, digits.sb = 2,
  digits.summary = 3, pvaluesAsNumbers = TRUE, boldpvalues = TRUE,
  separateConfColumn = TRUE, newLineConf = TRUE, showAbbrHeadline = TRUE,
  showICC = TRUE, showAIC = FALSE, remove.estimates = NULL,
  cellSpacing = 0.2, encoding = NULL, CSS = NULL, useViewer = TRUE,
  no.output = FALSE, remove.spaces = TRUE)
}
\arguments{
\item{...}{One or more mixed models fitted with \code{\link[lme4]{lmer}} or \code{\link[lmerTest]{lmer}}.}

\item{file}{The destination file, which will be in html-format. If no filepath is specified,
the file will be saved as temporary file and openend either in the RStudio View pane or
in the default web browser.}

\item{labelPredictors}{Labels of the predictor variables, provided as char vector.}

\item{labelDependentVariables}{Labels of the dependent variables of all fitted models
which have been used as first parameter(s), provided as char vector.}

\item{stringPredictors}{String constant used as headline for the predictor column.
Default is \code{"Predictors"}.}

\item{stringDependentVariables}{String constant used as headline for the
dependent variable columns. Default is \code{"Dependent Variables"}.}

\item{stringModel}{String constant used as headline for the model names in case no
labels for the dependent variables are provided (see labelDependentVariables).
Default is \code{"Model"}.}

\item{showHeaderStrings}{If \code{TRUE}, the header strings \code{stringPredictors}
and \code{stringDependentVariables} are shown. By default, they're hidden.}

\item{stringIntercept}{String constant used as headline for the Intercept row
default is \code{"Intercept"}.}

\item{stringObservations}{String constant used in the summary row for the count of observation
(cases). Default is \code{"Observations"}.}

\item{stringB}{String used for the column heading of beta coefficients. Default is \code{"B"}.}

\item{stringSB}{String used for the column heading of standardized beta coefficients. Default is \code{"std. Beta"}.}

\item{stringCI}{String used for the column heading of confidence interval values. Default is \code{"CI"}.}

\item{stringSE}{String used for the column heading of standard error values. Default is \code{"std. Error"}.}

\item{stringP}{String used for the column heading of p values. Default is \code{"p"}.}

\item{showEst}{If \code{TRUE} (default), the estimates are printed.}

\item{showConfInt}{If \code{TRUE} (default), the confidence intervall is also printed to the table. Use
\code{FALSE} to omit the CI in the table.}

\item{showStdBeta}{If \code{TRUE}, the standardized beta-coefficients are also printed.
Default is \code{FALSE}.}

\item{showStdError}{If \code{TRUE}, the standard errors are also printed.
Default is \code{FALSE}.}

\item{digits.est}{Amount of decimals for estimators.}

\item{digits.p}{Amount of decimals for p-values.}

\item{digits.ci}{Amount of decimals for confidence intervals.}

\item{digits.se}{Amount of decimals for standard error.}

\item{digits.sb}{Amount of decimals for standardized beta.}

\item{digits.summary}{Amount of decimals for values in model summary.}

\item{pvaluesAsNumbers}{If \code{TRUE}, p-values are shown as numbers. If \code{FALSE} (default),
p-values are indicated by asterisks.}

\item{boldpvalues}{If \code{TRUE} (default), significant p-values are shown bold faced.}

\item{separateConfColumn}{if \code{TRUE}, the CI values are shown in a separate table column.
Default is \code{FALSE}.}

\item{newLineConf}{If \code{TRUE} and \code{separateConfColumn} is \code{FALSE}, inserts a line break
between B and CI values. If \code{FALSE}, CI values are printed in the same
line with B values.}

\item{showAbbrHeadline}{If \code{TRUE} (default), the table data columns have a headline with
abbreviations for beta- and std. beta-values, confidence interval and p-values.}

\item{showICC}{If \code{TRUE}, the intra-class-correlation for each model is printed
in the model summary.}

\item{showAIC}{If \code{TRUE}, the AIC value for each model is printed
in the model summary. Default is \code{FALSE}.}

\item{remove.estimates}{numeric vector with indices (order equals to row index of \code{coef(fit)})
or character vector with coefficient names that indicate which estimates should be removed
from the table output. The first estimate is the intercept, followed by the model predictors.
\emph{The intercept cannot be removed from the table output!} \code{remove.estimates = c(2:4)}
would remove the 2nd to the 4th estimate (1st to 3d predictor after intercept) from the output.
\code{remove.estimates = "est_name"} would remove the estimate \emph{est_name}. Default
is \code{NULL}, i.e. all estimates are printed.}

\item{cellSpacing}{The inner padding of table cells. By default, this value is 0.2 (unit is cm), which is
suitable for viewing the table. Decrease this value (0.05 to 0.1) if you want to import the table
into Office documents. This is a convenient parameter for the \code{CSS} parameter for changing
cell spacing, which would be: \code{CSS=list(css.thead="padding:0.2cm;", css.tzdata="padding:0.2cm;")}.}

\item{encoding}{The charset encoding used for variable and value labels. Default is \code{NULL}, so encoding
will be auto-detected depending on your platform (\code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g.) German umlauts).}

\item{CSS}{A \code{\link{list}} with user-defined style-sheet-definitions, according to the
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. See 'Details'.}

\item{useViewer}{If \code{TRUE}, the function tries to show the HTML table in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{If \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}

\item{remove.spaces}{logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{output.complete}) and
           \item the html-table with inline-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Summarizes (multiple) fitted linear mixed effects models
               (beta coefficients, std. beta values etc.)  as HTML table,
               or saves them as file. The fitted models may have different
               predictors, e.g. when comparing different stepwise fitted models.
}
\details{
See 'Details' in \code{\link{sjt.frq}}.
}
\note{
See 'Notes' in \code{\link{sjt.frq}}.
}
\examples{
\dontrun{
library(lme4)
library(sjmisc)
data(efc)

# prepare group variable
efc$grp = as.factor(efc$e15relat)
levels(x = efc$grp) <- get_val_labels(efc$e15relat)
efc$care.level <- as.factor(sjmisc::rec(efc$n4pstu, "0=0;1=1;2=2;3:4=4"))
levels(x = efc$care.level) <- c("none", "I", "II", "III")

# data frame for fitted model
mydf <- data.frame(neg_c_7 = as.numeric(efc$neg_c_7),
                   sex = as.factor(efc$c161sex),
                   c12hour = as.numeric(efc$c12hour),
                   barthel = as.numeric(efc$barthtot),
                   education = as.factor(efc$c172code),
                   grp = efc$grp,
                   carelevel = efc$care.level)

# fit two sample models
fit1 <- lmer(neg_c_7 ~ sex + c12hour + barthel + (1|grp), data = mydf)
fit2 <- lmer(neg_c_7 ~ sex + c12hour + education + barthel + (1|grp), data = mydf)
fit3 <- lmer(neg_c_7 ~ sex + c12hour + education + barthel +
              (1|grp) +
              (1|carelevel), data = mydf)

# print summary table
sjt.lmer(fit1, fit2)

sjt.lmer(fit1, fit2,
         showAIC = TRUE,
         showConfInt = FALSE,
         showStdError = TRUE,
         pvaluesAsNumbers = FALSE)

sjt.lmer(fit1, fit2, fit3,
         showAIC = TRUE,
         separateConfColumn = FALSE,
         newLineConf = FALSE)}
}
\seealso{
\href{http://strengejacke.de/sjPlot/sjt.lmer/}{sjPlot manual: sjt.lmer}
           and \code{\link{sjt.lm}} for further examples.
}

