% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjTabFrequencies.R
\name{sjt.frq}
\alias{sjt.frq}
\title{Summary of frequencies as HTML table}
\usage{
sjt.frq(data, file = NULL, weightBy = NULL,
  weightByTitleString = " (weighted)", variableLabels = NULL,
  valueLabels = NULL, autoGroupAt = NULL, sort.frq = NULL,
  alternateRowColors = FALSE, stringValue = "value", stringCount = "N",
  stringPerc = "raw \%", stringValidPerc = "valid \%",
  stringCumPerc = "cumulative \%", stringMissingValue = "missings",
  highlightMedian = FALSE, highlightQuartiles = FALSE,
  skipZeroRows = "auto", showSummary = TRUE, showSkew = FALSE,
  showKurtosis = FALSE, skewString = "&gamma;",
  kurtosisString = "&omega;", digits = 2, removeStringVectors = TRUE,
  autoGroupStrings = TRUE, maxStringDist = 3, encoding = NULL,
  CSS = NULL, useViewer = TRUE, no.output = FALSE, remove.spaces = TRUE)
}
\arguments{
\item{data}{variables which frequencies should be printed as table. Either use a single variable
(vector) or a data frame where each column represents a variable (see 'Examples').}

\item{file}{destination file, if the output should be saved as file.
If \code{NULL} (default), the output will be saved as temporary file and 
openend either in the IDE's viewer pane or the default web browser.}

\item{weightBy}{weight factor that will be applied to weight all cases from \code{data}.
Must be a vector of same length as \code{nrow(data)}. Default is \code{NULL}, so no weights are used.}

\item{weightByTitleString}{suffix (as string) for the tabel caption, if \code{weightBy} is specified,
e.g. \code{weightByTitleString=" (weighted)"}. Default is \code{NULL}, so
the table caption will not have a suffix when cases are weighted.}

\item{variableLabels}{character vector or a list of character vectors that indicate
the variable names of \code{data} and will be used as variable labels
in the output. Note that if multiple variables
are supplied (if \code{data} is a \code{\link{data.frame}}), the variable 
labels must be supplied as \code{list} object (see 'Examples').}

\item{valueLabels}{list of character vectors that indicate the value labels of
\code{data}. Note that if multiple variables are supplied (if \code{data} is a \code{\link{data.frame}}), 
the value labels must be supplied as nested \code{list} object (see 'Examples').}

\item{autoGroupAt}{numeric value, indicating at which length of unique values of \code{data}, 
automatic grouping into smaller units is done (see \code{\link[sjmisc]{group_var}}).
Variables with large numbers of unique values may be too time consuming when 
a HTML table is created and R would not respond any longer, or the resulting table 
would be to too long and confusing. Hence it's recommended to group such variables. 
If \code{autoGroupAt = 50} and \code{varCount} has more than 50 unique values,
it will be grouped (using the \code{\link[sjmisc]{group_var}} function). 
Default value for \code{autoGroupAt} is \code{NULL}, i.e. auto-grouping is off.
See \code{\link[sjmisc]{group_var}} for examples on grouping.}

\item{sort.frq}{whether frequencies should be sorted or not. Use \code{"asc"} or \code{"ascending"}
to sort frequencies ascending, or \code{"desc"} or \code{"descending"} to sort
frequencies in descending order. By default, \code{sort.frq} is \code{NULL}, i.e.
frequencies are ordered by values.}

\item{alternateRowColors}{logical, if \code{TRUE}, alternating rows are highlighted with a light gray
background color.}

\item{stringValue}{label for the very first table column containing the values (see
\code{valueLabels}).}

\item{stringCount}{label for the first table data column containing the counts. Default is \code{"N"}.}

\item{stringPerc}{label for the second table data column containing the raw percentages. Default is \code{"raw \%"}.}

\item{stringValidPerc}{String label for the third data table column containing the valid percentages, i.e. the
count percentage value exluding possible missing values.}

\item{stringCumPerc}{String label for the last table data column containing the cumulative percentages.}

\item{stringMissingValue}{String label for the last table data row containing missing values.}

\item{highlightMedian}{If \code{TRUE}, the table row indicating the median value will
be highlighted.}

\item{highlightQuartiles}{If \code{TRUE}, the table row indicating the lower and upper quartiles will
be highlighted.}

\item{skipZeroRows}{If \code{TRUE}, rows with only zero-values are not printed
(e.g. if a variable has values or levels 1 to 8, and levels / values 
4 to 6 have no counts, these values would not be printed in the table). 
Use \code{FALSE} to print also zero-values, or use \code{"auto"} (default)
to detect whether it makes sense or not to print zero-values (e.g., a variable
"age" with values from 10 to 100, where at least 25 percent of all possible values have no
counts, zero-values would be skipped automatically).}

\item{showSummary}{If \code{TRUE} (default), a summary row with total and valid N as well as mean and
standard deviation is shown.}

\item{showSkew}{If \code{TRUE}, the variable's skewness is added to the summary.
The skewness is retrieved from the \code{\link[psych]{describe}}-function 
of the \pkg{psych}-package.}

\item{showKurtosis}{If \code{TRUE}, the variable's kurtosis is added to the summary.
The kurtosis is retrieved from the \code{\link[psych]{describe}}-function 
of the \pkg{psych}-package.}

\item{skewString}{A character string, which is used as header for the skew 
column (see \code{showSkew})). Default is lower case Greek gamma.}

\item{kurtosisString}{A character string, which is used as header for the 
kurtosis column (see \code{showKurtosis})). Default is lower case 
Greek omega.}

\item{digits}{amount of digits used for table values. Default is 2.}

\item{removeStringVectors}{If \code{TRUE} (default), character vectors / string variables will be removed from
\code{data} before frequency tables are computed.}

\item{autoGroupStrings}{if \code{TRUE} (default), string values in character 
vectors (string variables) are automatically grouped based on their 
similarity. The similarity is estimated with the \pkg{stringdist}-package.
You can specify a distance-measure via \code{maxStringDist} argument. This argument only
applies if \code{removeStringVectors} is \code{FALSE}.}

\item{maxStringDist}{the allowed distance of string values in a character vector, which indicates
when two string values are merged because they are considered as close enough.}

\item{encoding}{string, indicating the charset encoding used for variable and 
value labels. Default is \code{NULL}, so encoding will be auto-detected 
depending on your platform (e.g., \code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g. German umlauts).}

\item{CSS}{\code{\link{list}}-object with user-defined style-sheet-definitions, according to the 
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. See 'Details'.}

\item{useViewer}{If \code{TRUE}, the function tries to show the HTML table in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{logical, if \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}

\item{remove.spaces}{logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item each frequency table as web page content (\code{page.content.list}),
           \item the complete html-output (\code{output.complete}) and
           \item the html-table with inline-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Shows (multiple) frequency tables as HTML file, or saves them as file.
}
\details{
\bold{How does the \code{CSS}-argument work?}
           \cr \cr
           With the \code{CSS}-paramater, the visual appearance of the tables
           can be modified. To get an overview of all style-sheet-classnames 
           that are used in this function, see return value \code{page.style} for details. 
           Arguments for this list have following syntax:
         \enumerate{
           \item the class-names with \code{"css."}-prefix as argument name and
           \item each style-definition must end with a semicolon
         } 
         You can add style information to the default styles by using a + (plus-sign) as
         initial character for the argument attributes. Examples:
         \itemize{
           \item \code{css.table = 'border:2px solid red;'} for a solid 2-pixel table border in red.
           \item \code{css.summary = 'font-weight:bold;'} for a bold fontweight in the summary row.
           \item \code{css.lasttablerow = 'border-bottom: 1px dotted blue;'} for a blue dotted border of the last table row.
           \item \code{css.colnames = '+color:green'} to add green color formatting to column names.
           \item \code{css.arc = 'color:blue;'} for a blue text color each 2nd row.
           \item \code{css.caption = '+color:red;'} to add red font-color to the default table caption style.
         }
         See further examples at \href{http://www.strengejacke.de/sjPlot/sjtbasics}{sjPlot manual: sjt-basics}.
}
\note{
The HTML tables can either be saved as file and manually opened (specify argument \code{file}) or
        they can be saved as temporary files and will be displayed in the RStudio Viewer pane (if working with RStudio)
        or opened with the default web browser. Displaying resp. opening a temporary file is the
        default behaviour (i.e. \code{file = NULL}).
}
\examples{
\dontrun{
# load sample data
library(sjmisc)
data(efc)

# show frequencies of "e42dep" in RStudio Viewer Pane
# or default web browser
sjt.frq(efc$e42dep)

# plot and show frequency table of "e42dep" with labels
sjt.frq(efc$e42dep,
        variableLabels = "Dependency",
        valueLabels = c("independent",
                        "slightly dependent",
                        "moderately dependent",
                        "severely dependent"))

# plot frequencies of e42dep, e16sex and c172code in one HTML file
# and show table in RStudio Viewer Pane or default web browser
# Note that valueLabels of multiple variables have to be
# list-objects
sjt.frq(data.frame(efc$e42dep, efc$e16sex, efc$c172code),
        variableLabels = c("Dependency", 
                           "Gender", 
                           "Education"),
        valueLabels = list(c("independent",
                             "slightly dependent",
                             "moderately dependent",
                             "severely dependent"),
                           c("male", "female"),
                           c("low", "mid", "high")))

# -------------------------------
# auto-detection of labels
# due to auto-detection of labels, this works as well
# -------------------------------
sjt.frq(data.frame(efc$e42dep, efc$e16sex, efc$c172code))


# plot larger scale including zero-counts
# indicating median and quartiles
sjt.frq(efc$neg_c_7,
        highlightMedian = TRUE,
        highlightQuartiles = TRUE)

# -------------------------------
# sort frequencies
# -------------------------------
sjt.frq(efc$e42dep, sort.frq = "desc")

# -------------------------------- 
# User defined style sheet
# -------------------------------- 
sjt.frq(efc$e42dep,
        CSS = list(css.table = "border: 2px solid;",
                   css.tdata = "border: 1px solid;",
                   css.firsttablecol = "color:#003399; font-weight:bold;"))}

}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/sjt.frq/}{sjPlot manual: sjt.frq}
           \item \code{\link{sjp.frq}}
         }
}

