% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotOddsMultiple.R
\name{sjp.glmm}
\alias{sjp.glmm}
\title{Plot estimates of multiple fitted glm(er)'s}
\usage{
sjp.glmm(..., remove.estimates = NULL, title = NULL, depvar.labels = NULL,
  legend.title = "Dependent Variables", legend.pval.title = "p-level",
  axis.labels = NULL, axis.title = "Estimates", axis.lim = NULL,
  wrap.title = 50, wrap.labels = 25, wrap.legend.title = 20,
  grid.breaks = 0.5, trns.ticks = TRUE, geom.size = 3,
  geom.spacing = 0.4, geom.colors = "Set1", show.values = TRUE,
  show.legend = TRUE, show.intercept = FALSE, show.p = TRUE,
  fade.ns = FALSE, p.shape = FALSE, vline.type = 2,
  vline.color = "grey70", digits = 2, facet.grid = FALSE,
  coord.flip = TRUE, prnt.plot = TRUE)
}
\arguments{
\item{...}{one or more fitted \code{glm}- or \code{glmerMod}-objects. May 
also be a \code{\link{list}}-object with 
fitted models, instead of separating each model with comma. See 'Examples'.}

\item{remove.estimates}{character vector with coefficient names that indicate
which estimates should be removed from the plot.
\code{remove.estimates = "est_name"} would remove the estimate \emph{est_name}. Default
is \code{NULL}, i.e. all estimates are printed.}

\item{title}{character vector, used as plot title. Depending on plot type and function,
will be set automatically. If \code{title = ""}, no title is printed.}

\item{depvar.labels}{character vector with labels of dependent 
variables of all fitted models. See 'Examples'.}

\item{legend.title}{character vector, used as title for the plot legend. Note that
only some plot types have legends (e.g. \code{type = "pred"} or when
grouping estimates with \code{group.estimates}).}

\item{legend.pval.title}{character vector, used as title of the plot legend that 
indicates the p-values. Default is \code{"p-level"}. Only applies if \code{p.shape = TRUE}.}

\item{axis.labels}{character vector with labels used as axis labels. Optional
argument, since in most cases, axis labels are set automatically.}

\item{axis.title}{character vector of length one or two (depending on
the plot function and type), used as title(s) for the x and y axis. 
If not specified, a default labelling  is chosen.}

\item{axis.lim}{numeric vector of length 2, defining the range of the plot axis.
Depending on plot type, may effect either x- or y-axis, or both.
For multiple plot outputs (e.g., from \code{type = "eff"} or 
\code{type = "slope"} in \code{\link{sjp.glm}}), \code{axis.lim} may
also be a list of vectors of length 2, defining axis limits for each
plot (only if non-faceted).}

\item{wrap.title}{numeric, determines how many chars of the plot title are displayed in
one line and when a line break is inserted.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis 
labels are displayed in one line and when a line break is inserted.}

\item{wrap.legend.title}{numeric, determines how many chars of the legend's title 
are displayed in one line and when a line break is inserted.}

\item{grid.breaks}{numeric; sets the distance between breaks for the axis, 
i.e. at every \code{grid.breaks}'th position a major grid is being printed.}

\item{trns.ticks}{logical, if \code{TRUE}, the grid lines have exponential 
distances (equidistant), i.e. they visually have the same distance from 
one panel grid to the next. If \code{FALSE}, grids are 
plotted on every \code{grid.breaks}'s position, thus the grid lines become narrower with 
higher odds ratio values.}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size, 
depending on plot type and function). Note that bar and bin widths mostly 
need smaller values than dot sizes.}

\item{geom.spacing}{spacing between the dots and error bars of the plotted fitted models. Default
is 0.3.}

\item{geom.colors}{user defined color palette for geoms. If \code{group.estimates}
is \emph{not} specified, must either be vector with two color values or a specific
color palette code (see 'Details' in \code{\link{sjp.grpfrq}}). Else, if
\code{group.estimates} is specified, \code{geom.colors} must be a vector
of same length as groups. See 'Examples'.}

\item{show.values}{logical, whether values should be plotted or not.}

\item{show.legend}{logical, if \code{TRUE}, and depending on plot type and
function, a legend is added to the plot.}

\item{show.intercept}{logical, if \code{TRUE}, the intercept of the fitted model is also plotted.
Default is \code{FALSE}. For \code{glm}'s, please note that due to exponential 
transformation of estimates, the intercept in some cases can not be calculated, thus the
function call is interrupted and no plot printed.}

\item{show.p}{logical, adds significance levels to values, or value and 
variable labels.}

\item{fade.ns}{if \code{TRUE}, non significant estimates will be printed in slightly faded colors.}

\item{p.shape}{If \code{TRUE}, significant levels are distinguished by different point shapes and a related
legend is plotted. Default is \code{FALSE}.}

\item{vline.type}{linetype of the vertical "zero point" line. Default is \code{2} (dashed line).}

\item{vline.color}{color of the vertical "zero point" line. Default value is \code{"grey70"}.}

\item{digits}{numeric, amount of digits after decimal point when rounding estimates and values.}

\item{facet.grid}{\code{TRUE} to arrange the lay out of of multiple plots 
in a grid of an integrated single plot. This argument calls 
\code{\link[ggplot2]{facet_wrap}} or \code{\link[ggplot2]{facet_grid}}
to arrange plots. Use \code{\link{plot_grid}} to plot multiple plot-objects 
as an arranged grid with \code{\link[gridExtra]{grid.arrange}}.}

\item{coord.flip}{logical, if \code{TRUE}, the x and y axis are swapped.}

\item{prnt.plot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{data}).
}
\description{
Plot and compare odds or incidents ratios (forest plots) of multiple fitted 
               generalized linear (mixed effects) models with confidence 
               intervals in one plot.
}
\note{
The fitted models may have differing predictors, but only in a 
        "stepwise" sense; i.e., models should share a common set of predictors,
        while some models may have additional predictors (e.g. added via
        the \code{\link[stats]{update}} function). See 'Examples'.
}
\examples{
# prepare dummy variables for binary logistic regression
y1 <- ifelse(swiss$Fertility < median(swiss$Fertility), 0, 1)
y2 <- ifelse(swiss$Infant.Mortality < median(swiss$Infant.Mortality), 0, 1)
y3 <- ifelse(swiss$Agriculture<median(swiss$Agriculture), 0, 1)

# Now fit the models. Note that all models share the same predictors
# and only differ in their dependent variable (y1, y2 and y3)
fitOR1 <- glm(y1 ~ swiss$Education + swiss$Examination + swiss$Catholic,
              family = binomial(link = "logit"))
fitOR2 <- glm(y2 ~ swiss$Education + swiss$Examination + swiss$Catholic,
              family = binomial(link = "logit"))
fitOR3 <- glm(y3 ~ swiss$Education + swiss$Examination + swiss$Catholic,
              family = binomial(link = "logit"))

# plot multiple models
sjp.glmm(fitOR1, fitOR2, fitOR3, facet.grid = TRUE)

# plot multiple models with legend labels and point shapes instead of value  labels
sjp.glmm(fitOR1, fitOR2, fitOR3,
         depvar.labels = c("Fertility", "Infant Mortality", "Agriculture"),
         show.values = FALSE, show.p = FALSE, fade.ns = TRUE, p.shape = TRUE)

# plot multiple models from nested lists argument
all.models <- list()
all.models[[1]] <- fitOR1
all.models[[2]] <- fitOR2
all.models[[3]] <- fitOR3

sjp.glmm(all.models)

# -------------------------------
# Predictors for negative impact
# of care. Data from the EUROFAMCARE
# sample dataset
# -------------------------------
library(sjmisc)
data(efc)

# create binary response
y <- ifelse(efc$neg_c_7 < median(na.omit(efc$neg_c_7)), 0, 1)
# create dummy variables for educational status
mydf <- data.frame(y = as.factor(y),
                   sex = efc$c161sex,
                   dep = to_factor(efc$e42dep),
                   barthel = efc$barthtot,
                   education = to_factor(efc$c172code))

fit1 <- glm(y ~ sex + education,  data = mydf, family = binomial(link = "logit"))
fit2 <- update(fit1, . ~ . + barthel)
fit3 <- update(fit2, . ~ . + dep)

sjp.glmm(fit1, fit2, fit3)

}

