% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotxtab.R
\name{plot_xtab}
\alias{plot_xtab}
\alias{sjp.xtab}
\title{Plot contingency tables}
\usage{
plot_xtab(
  x,
  grp,
  type = c("bar", "line"),
  margin = c("col", "cell", "row"),
  bar.pos = c("dodge", "stack"),
  title = "",
  title.wtd.suffix = NULL,
  axis.titles = NULL,
  axis.labels = NULL,
  legend.title = NULL,
  legend.labels = NULL,
  weight.by = NULL,
  rev.order = FALSE,
  show.values = TRUE,
  show.n = TRUE,
  show.prc = TRUE,
  show.total = TRUE,
  show.legend = TRUE,
  show.summary = FALSE,
  summary.pos = "r",
  drop.empty = TRUE,
  string.total = "Total",
  wrap.title = 50,
  wrap.labels = 15,
  wrap.legend.title = 20,
  wrap.legend.labels = 20,
  geom.size = 0.7,
  geom.spacing = 0.1,
  geom.colors = "Paired",
  dot.size = 3,
  smooth.lines = FALSE,
  grid.breaks = 0.2,
  expand.grid = FALSE,
  ylim = NULL,
  vjust = "bottom",
  hjust = "center",
  y.offset = NULL,
  coord.flip = FALSE
)

sjp.xtab(
  x,
  grp,
  type = c("bar", "line"),
  margin = c("col", "cell", "row"),
  bar.pos = c("dodge", "stack"),
  title = "",
  title.wtd.suffix = NULL,
  axis.titles = NULL,
  axis.labels = NULL,
  legend.title = NULL,
  legend.labels = NULL,
  weight.by = NULL,
  rev.order = FALSE,
  show.values = TRUE,
  show.n = TRUE,
  show.prc = TRUE,
  show.total = TRUE,
  show.legend = TRUE,
  show.summary = FALSE,
  summary.pos = "r",
  drop.empty = TRUE,
  string.total = "Total",
  wrap.title = 50,
  wrap.labels = 15,
  wrap.legend.title = 20,
  wrap.legend.labels = 20,
  geom.size = 0.7,
  geom.spacing = 0.1,
  geom.colors = "Paired",
  dot.size = 3,
  smooth.lines = FALSE,
  grid.breaks = 0.2,
  expand.grid = FALSE,
  ylim = NULL,
  vjust = "bottom",
  hjust = "center",
  y.offset = NULL,
  coord.flip = FALSE
)
}
\arguments{
\item{x}{A vector of values (variable) describing the bars which make up the plot.}

\item{grp}{Grouping variable of same length as \code{x}, where \code{x}
is grouped into the categories represented by \code{grp}.}

\item{type}{Plot type. may be either \code{"bar"} (default) for bar charts,
or \code{"line"} for line diagram.}

\item{margin}{Indicates which data of the proportional table should be plotted. Use \code{"row"} for
calculating row percentages, \code{"col"} for column percentages and \code{"cell"} for cell percentages.
If \code{margin = "col"}, an additional bar with the total sum of each column
can be added to the plot (see \code{show.total}).}

\item{bar.pos}{Indicates whether bars should be positioned side-by-side (default),
or stacked (\code{bar.pos = "stack"}). May be abbreviated.}

\item{title}{character vector, used as plot title. Depending on plot type and function,
will be set automatically. If \code{title = ""}, no title is printed.
For effect-plots, may also be a character vector of length > 1,
to define titles for each sub-plot or facet.}

\item{title.wtd.suffix}{Suffix (as string) for the title, if \code{weight.by} is specified,
e.g. \code{title.wtd.suffix=" (weighted)"}. Default is \code{NULL}, so
title will not have a suffix when cases are weighted.}

\item{axis.titles}{character vector of length one or two, defining the title(s)
for the x-axis and y-axis.}

\item{axis.labels}{character vector with labels used as axis labels. Optional
argument, since in most cases, axis labels are set automatically.}

\item{legend.title}{character vector, used as title for the plot legend.}

\item{legend.labels}{character vector with labels for the guide/legend.}

\item{weight.by}{Vector of weights that will be applied to weight all cases.
Must be a vector of same length as the input vector. Default is
\code{NULL}, so no weights are used.}

\item{rev.order}{Logical, if \code{TRUE}, order of categories (groups) is reversed.}

\item{show.values}{Logical, whether values should be plotted or not.}

\item{show.n}{logical, if \code{TRUE}, adds total number of cases for each
group or category to the labels.}

\item{show.prc}{logical, if \code{TRUE} (default), percentage values are plotted to each bar
If \code{FALSE}, percentage values are removed.}

\item{show.total}{When \code{margin = "col"}, an additional bar
with the sum within each category and it's percentages will be added
to each category.}

\item{show.legend}{logical, if \code{TRUE}, and depending on plot type and
function, a legend is added to the plot.}

\item{show.summary}{logical, if \code{TRUE} (default), a summary with chi-squared
statistics (see \code{\link{chisq.test}}), Cramer's V or Phi-value etc.
is shown. If a cell contains expected values lower than five (or lower than 10
if df is 1), the Fisher's excact test (see \code{\link{fisher.test}}) is
computed instead of chi-squared test. If the table's matrix is larger
than 2x2, Fisher's excact test with Monte Carlo simulation is computed.}

\item{summary.pos}{position of the model summary which is printed when \code{show.summary}
is \code{TRUE}. Default is \code{"r"}, i.e. it's printed to the upper right corner.
Use \code{"l"} for upper left corner.}

\item{drop.empty}{Logical, if \code{TRUE} and the variable's values are labelled,
values that have no observations are still printed in the table (with
frequency \code{0}). If \code{FALSE}, values / factor levels with no occurence
in the data are omitted from the output.}

\item{string.total}{String for the legend label when a total-column is added. Only applies
if \code{show.total = TRUE}. Default is \code{"Total"}.}

\item{wrap.title}{numeric, determines how many chars of the plot title are displayed in
one line and when a line break is inserted.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis
labels are displayed in one line and when a line break is inserted.}

\item{wrap.legend.title}{numeric, determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{wrap.legend.labels}{numeric, determines how many chars of the legend labels are
displayed in one line and when a line break is inserted.}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size,
depending on plot type and function). Note that bar and bin widths mostly
need smaller values than dot sizes.}

\item{geom.spacing}{the spacing between geoms (i.e. bar spacing)}

\item{geom.colors}{user defined color for geoms. See 'Details' in \code{\link{plot_grpfrq}}.}

\item{dot.size}{Dot size, only applies, when argument \code{type = "line"}.}

\item{smooth.lines}{prints a smooth line curve. Only applies, when argument \code{type = "line"}.}

\item{grid.breaks}{numeric; sets the distance between breaks for the axis,
i.e. at every \code{grid.breaks}'th position a major grid is being printed.}

\item{expand.grid}{logical, if \code{TRUE}, the plot grid is expanded, i.e. there is a small margin between
axes and plotting region. Default is \code{FALSE}.}

\item{ylim}{numeric vector of length two, defining lower and upper axis limits
of the y scale. By default, this argument is set to \code{NULL}, i.e. the
y-axis fits to the required range of the data.}

\item{vjust}{character vector, indicating the vertical position of value
labels. Allowed are same values as for \code{vjust} aesthetics from
\code{ggplot2}: "left", "center", "right", "bottom", "middle", "top" and
new options like "inward" and "outward", which align text towards and
away from the center of the plot respectively.}

\item{hjust}{character vector, indicating the horizontal position of value
labels. Allowed are same values as for \code{vjust} aesthetics from
\code{ggplot2}: "left", "center", "right", "bottom", "middle", "top" and
new options like "inward" and "outward", which align text towards and
away from the center of the plot respectively.}

\item{y.offset}{numeric, offset for text labels when their alignment is adjusted
to the top/bottom of the geom (see \code{hjust} and \code{vjust}).}

\item{coord.flip}{logical, if \code{TRUE}, the x and y axis are swapped.}
}
\value{
A ggplot-object.
}
\description{
Plot proportional crosstables (contingency tables) of two variables as ggplot diagram.
}
\examples{
# create 4-category-items
grp <- sample(1:4, 100, replace = TRUE)
# create 3-category-items
x <- sample(1:3, 100, replace = TRUE)

# plot "cross tablulation" of x and grp
plot_xtab(x, grp)

# plot "cross tablulation" of x and y, including labels
plot_xtab(x, grp, axis.labels = c("low", "mid", "high"),
         legend.labels = c("Grp 1", "Grp 2", "Grp 3", "Grp 4"))

# plot "cross tablulation" of x and grp
# as stacked proportional bars
plot_xtab(x, grp, margin = "row", bar.pos = "stack",
         show.summary = TRUE, coord.flip = TRUE)

# example with vertical labels
library(sjmisc)
library(sjlabelled)
data(efc)
set_theme(geom.label.angle = 90)
plot_xtab(efc$e42dep, efc$e16sex, vjust = "center", hjust = "bottom")

# grouped bars with EUROFAMCARE sample dataset
# dataset was importet from an SPSS-file,
# see ?sjmisc::read_spss
data(efc)
efc.val <- get_labels(efc)
efc.var <- get_label(efc)

plot_xtab(efc$e42dep, efc$e16sex, title = efc.var['e42dep'],
         axis.labels = efc.val[['e42dep']], legend.title = efc.var['e16sex'],
         legend.labels = efc.val[['e16sex']])

plot_xtab(efc$e16sex, efc$e42dep, title = efc.var['e16sex'],
         axis.labels = efc.val[['e16sex']], legend.title = efc.var['e42dep'],
         legend.labels = efc.val[['e42dep']])

# -------------------------------
# auto-detection of labels works here
# so no need to specify labels. For
# title-auto-detection, use NULL
# -------------------------------
plot_xtab(efc$e16sex, efc$e42dep, title = NULL)

plot_xtab(efc$e16sex, efc$e42dep, margin = "row",
         bar.pos = "stack", coord.flip = TRUE)

}
