% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_corr.R
\name{tab_corr}
\alias{tab_corr}
\title{Summary of correlations as HTML table}
\usage{
tab_corr(
  data,
  na.deletion = c("listwise", "pairwise"),
  corr.method = c("pearson", "spearman", "kendall"),
  title = NULL,
  var.labels = NULL,
  wrap.labels = 40,
  show.p = TRUE,
  p.numeric = FALSE,
  fade.ns = TRUE,
  val.rm = NULL,
  digits = 3,
  triangle = "both",
  string.diag = NULL,
  CSS = NULL,
  encoding = NULL,
  file = NULL,
  use.viewer = TRUE,
  remove.spaces = TRUE
)
}
\arguments{
\item{data}{Matrix with correlation coefficients as returned by the
\code{\link{cor}}-function, or a \code{data.frame} of variables where
correlations between columns should be computed.}

\item{na.deletion}{Indicates how missing values are treated. May be either
\code{"listwise"} (default) or \code{"pairwise"}. May be
abbreviated.}

\item{corr.method}{Indicates the correlation computation method. May be one of
\code{"pearson"} (default), \code{"spearman"} or \code{"kendall"}.
May be abbreviated.}

\item{title}{String, will be used as table caption.}

\item{var.labels}{Character vector with variable names, which will be used
to label variables in the output.}

\item{wrap.labels}{Numeric, determines how many chars of the value, variable
or axis labels are displayed in one line and when a line break is inserted.}

\item{show.p}{Logical, if \code{TRUE}, p-values are also printed.}

\item{p.numeric}{Logical, if \code{TRUE}, the p-values are printed
as numbers. If \code{FALSE} (default), asterisks are used.}

\item{fade.ns}{Logical, if \code{TRUE} (default), non-significant correlation-values
appear faded (by using a lighter grey text color). See 'Note'.}

\item{val.rm}{Specify a number between 0 and 1 to suppress the output of correlation values
that are smaller than \code{val.rm}. The absolute correlation values are used, so
a correlation value of \code{-.5} would be greater than \code{val.rm = .4} and thus not be
omitted. By default, this argument is \code{NULL}, hence all values are shown in the table.
If a correlation value is below the specified value of \code{val.rm}, it is still printed to
the HTML table, but made "invisible" with white foreground color. You can use the \code{CSS}
argument (\code{"css.valueremove"}) to change color and appearance of those correlation value that are smaller than
the limit specified by \code{val.rm}.}

\item{digits}{Amount of decimals for estimates}

\item{triangle}{Indicates whether only the upper right (use \code{"upper"}), lower left (use \code{"lower"})
or both (use \code{"both"}) triangles of the correlation table is filled with values. Default
is \code{"both"}. You can specifiy the inital letter only.}

\item{string.diag}{A vector with string values of the same length as \code{ncol(data)} (number of
correlated items) that can be used to display content in the diagonal cells
where row and column item are identical (i.e. the "self-correlation"). By defauilt,
this argument is \code{NULL} and the diagnal cells are empty.}

\item{CSS}{A \code{\link{list}} with user-defined style-sheet-definitions,
according to the \href{http://www.w3.org/Style/CSS/}{official CSS syntax}.
See 'Details' or \href{https://strengejacke.github.io/sjPlot/articles/table_css.html}{this package-vignette}.}

\item{encoding}{Character vector, indicating the charset encoding used
for variable and value labels. Default is \code{"UTF-8"}. For Windows
Systems, \code{encoding = "Windows-1252"} might be necessary for proper
display of special characters.}

\item{file}{Destination file, if the output should be saved as file.
If \code{NULL} (default), the output will be saved as temporary file and
opened either in the IDE's viewer pane or the default web browser.}

\item{use.viewer}{Logical, if \code{TRUE}, the HTML table is shown in the IDE's
viewer pane. If \code{FALSE} or no viewer available, the HTML table is
opened in a web browser.}

\item{remove.spaces}{Logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{page.complete}) and
           \item the html-table with inline-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Shows the results of a computed correlation as HTML table. Requires either
               a \code{\link{data.frame}} or a matrix with correlation coefficients
               as returned by the \code{\link{cor}}-function.
}
\note{
If \code{data} is a matrix with correlation coefficients as returned by
      the \code{\link{cor}}-function, p-values can't be computed.
      Thus, \code{show.p}, \code{p.numeric} and \code{fade.ns}
      only have an effect if \code{data} is a \code{\link{data.frame}}.
}
\examples{
\dontrun{
if (interactive()) {
  # Data from the EUROFAMCARE sample dataset
  library(sjmisc)
  data(efc)

  # retrieve variable and value labels
  varlabs <- get_label(efc)

  # recveive first item of COPE-index scale
  start <- which(colnames(efc) == "c83cop2")
  # recveive last item of COPE-index scale
  end <- which(colnames(efc) == "c88cop7")

  # create data frame with COPE-index scale
  mydf <- data.frame(efc[, c(start:end)])
  colnames(mydf) <- varlabs[c(start:end)]

  # we have high correlations here, because all items
  # belong to one factor.
  tab_corr(mydf, p.numeric = TRUE)

  # auto-detection of labels, only lower triangle
  tab_corr(efc[, c(start:end)], triangle = "lower")

  # auto-detection of labels, only lower triangle, all correlation
  # values smaller than 0.3 are not shown in the table
  tab_corr(efc[, c(start:end)], triangle = "lower", val.rm = 0.3)

  # auto-detection of labels, only lower triangle, all correlation
  # values smaller than 0.3 are printed in blue
  tab_corr(efc[, c(start:end)], triangle = "lower",val.rm = 0.3,
           CSS = list(css.valueremove = 'color:blue;'))
}}
}
