% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_value.R
\name{as_numeric}
\alias{as_numeric}
\title{Convert factors to numeric variables}
\usage{
as_numeric(x, ..., start.at = NULL, keep.labels = TRUE,
  use.labels = FALSE)
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or tidyselect's
\code{\link[tidyselect]{select_helpers}}.
See 'Examples'.}

\item{start.at}{Starting index, i.e. the lowest numeric value of the variable's
value range. By default, this argument is \code{NULL}, hence the lowest
value of the returned numeric variable corresponds to the lowest factor
level (if factor levels are numeric) or to \code{1} (if factor levels
are not numeric).}

\item{keep.labels}{Logical, if \code{TRUE}, former factor levels will be added as
value labels. For numeric factor levels, values labels will be used,
if present. See 'Examples' and \code{\link{set_labels}} for more details.}

\item{use.labels}{Logical, if \code{TRUE} and \code{x} has numeric value labels,
the values defined in the labels (right-hand side of \code{labels}, for instance
\code{labels = c(null = 0, one = 1)}) will be set as numeric values (instead
of consecutive factor level numbers). See 'Examples'.}
}
\value{
A numeric variable with values ranging either from \code{start.at} to
          \code{start.at} + length of factor levels, or to the corresponding
          factor levels (if these were numeric). If \code{x} is a data frame,
          the complete data frame \code{x} will be returned, where variables
          specified in \code{...} are coerced to numeric; if \code{...} is
          not specified, applies to all variables in the data frame.
}
\description{
This function converts (replaces) factor levels with the
related factor level index number, thus the factor is converted to
a numeric variable.
}
\examples{
data(efc)
test <- as_label(efc$e42dep)
table(test)

table(as_numeric(test))
hist(as_numeric(test, start.at = 0))

# set lowest value of new variable to "5".
table(as_numeric(test, start.at = 5))

# numeric factor keeps values
dummy <- factor(c("3", "4", "6"))
table(as_numeric(dummy))

# do not drop unused factor levels
dummy <- ordered(c(rep("No", 5), rep("Maybe", 3)),
                 levels = c("Yes", "No", "Maybe"))
as_numeric(dummy)

# non-numeric factor is converted to numeric
# starting at 1
dummy <- factor(c("D", "F", "H"))
table(as_numeric(dummy))

# for numeric factor levels, value labels will be used, if present
dummy1 <- factor(c("3", "4", "6"))
dummy1 <- set_labels(dummy1, labels = c("first", "2nd", "3rd"))
dummy1
as_numeric(dummy1)

# for non-numeric factor levels, these will be used.
# value labels will be ignored
dummy2 <- factor(c("D", "F", "H"))
dummy2 <- set_labels(dummy2, labels = c("first", "2nd", "3rd"))
dummy2
as_numeric(dummy2)


# easily coerce specific variables in a data frame to numeric
# and keep other variables, with their class preserved
data(efc)
efc$e42dep <- as.factor(efc$e42dep)
efc$e16sex <- as.factor(efc$e16sex)
efc$e17age <- as.factor(efc$e17age)

# convert back "sex" and "age" into numeric
as_numeric(efc, e16sex, e17age)

x <- factor(c("None", "Little", "Some", "Lots"))
x <- set_labels(x,
  labels = c(None = "0.5", Little = "1.3", Some = "1.8", Lots = ".2")
)
x
as_numeric(x)
as_numeric(x, use.labels = TRUE)
as_numeric(x, use.labels = TRUE, keep.labels = FALSE)

}
