% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_na_flags.R
\name{get_na_flags}
\alias{get_na_flags}
\title{Retrieve missing value flags of labelled variables}
\usage{
get_na_flags(x)
}
\arguments{
\item{x}{Variable (vector) with value label attributes, including
missing value codes (see \code{\link{labelled}}).}
}
\value{
Logical vector with missing flags that indicate which labelled value
          is considered as missing.
}
\description{
This function retrieves the logical missing flags for a
               \code{\link{labelled}} variable.
}
\details{
See 'Details' in \code{\link{get_na}}.
}
\examples{
# create labelled integer, with missing flag
x <- labelled(c(1, 2, 1, 3, 4, 1),
              c(Male = 1, Female = 2, Refused = 3, "N/A" = 4),
              c(FALSE, FALSE, TRUE, TRUE))
get_na_flags(x)
}
\seealso{
\code{\link{get_na}} to get value codes of labelled missing values;
           \code{\link{get_values}} to get values associated with labels;
           see \code{\link{set_na}} to replace specific values with \code{NA}
           and \code{\link{to_na}} to convert missing value codes into \code{NA}.
}

