% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_labels.R
\name{set_labels}
\alias{set_labels}
\alias{set_labels<-}
\alias{set_val_labels}
\title{Add value labels to variables}
\usage{
set_labels(x, labels, force.labels = FALSE, force.values = TRUE)

set_labels(x, force.labels = FALSE, force.values = TRUE) <- value

set_val_labels(x, labels, force.labels = FALSE, force.values = TRUE)
}
\arguments{
\item{x}{Variable (vector), \code{list} of variables or a \code{data.frame}
where value label attributes should be added. Replaces former value labels.}

\item{labels}{(Named) character vector of labels that will be added to \code{x} as
\code{"labels"} or \code{"value.labels"} attribute.
\itemize{
  \item if \code{labels} is \strong{not} a \emph{named vector}, its length must equal the value range of \code{x}, i.e. if \code{x} has values from 1 to 3, \code{labels} should have a length of 3;
  \item if length of \code{labels} is intended to differ from length of unique values of \code{x}, a warning is given. You can still add missing labels with the \code{force.labels} or \code{force.values} arguments; see 'Note'.
  \item if \code{labels} \strong{is} a \emph{named vector}, value labels will be set accordingly, even if \code{x} has a different length of unique values. See 'Note' and 'Examples'.
  \item if \code{x} is a data frame, \code{labels} may also be a \code{\link{list}} of (named) character vectors;
  \item if \code{labels} is a \code{list}, it must have the same length as number of columns of \code{x};
  \item if \code{labels} is a vector and \code{x} is a data frame, \code{labels} will be applied to each column of \code{x}.
  }
Use \code{labels = ""} to remove labels-attribute from \code{x}.}

\item{force.labels}{Logical; if \code{TRUE}, all \code{labels} are added as value label
attribute, even if \code{x} has less unique values then length of \code{labels}
or if \code{x} has a smaller range then length of \code{labels}. See 'Examples'.
This parameter will be ignored, if \code{labels} is a named vector.}

\item{force.values}{Logical, if \code{TRUE} (default) and \code{labels} has less
elements than unique values of \code{x}, additional values not covered
by \code{labels} will be added as label as well. See 'Examples'.
This parameter will be ignored, if \code{labels} is a named vector.}

\item{value}{See \code{labels},}
}
\value{
\code{x} with value label attributes; or with removed label-attributes if
           \code{labels = ""}.
}
\description{
This function adds character \code{labels} as attribute
               (named \code{"labels"} or \code{"value.labels"}) to a variable
               or vector \code{x}, resp. to a set of variables in a
               \code{data.frame} or a \code{list}-object. These value labels will be accessed
               by functions of the \pkg{sjPlot} package, in order to automatically set values
               or legend labels, however, \pkg{sjmisc} provides functions to
               quickly access these attributes for other purposes.
}
\details{
See 'Details' in \code{\link{get_labels}}.
}
\note{
\itemize{
        \item if \code{labels} is a named vector, \code{force.labels} and \code{force.values} will be ignored, and only values defined in \code{labels} will be labelled;
        \item if \code{x} has less unique values than \code{labels}, redundant labels will be dropped, see \code{force.labels};
        \item if \code{x} has more unique values than \code{labels}, only matching values will be labelled, other values remain unlabelled, see \code{force.values};
        }
        If you only want to change partial value labels, use \code{\link{add_labels}} instead.
        Furthermore, see 'Note' in \code{\link{get_labels}}.
}
\examples{
\dontrun{
library(sjPlot)
dummy <- sample(1:4, 40, replace = TRUE)
sjp.frq(dummy)

dummy <- set_labels(dummy, c("very low", "low", "mid", "hi"))
sjp.frq(dummy)}

# force using all labels, even if not all labels
# have associated values in vector
x <- c(2, 2, 3, 3, 2)
# only two value labels
x <- set_labels(x, c("1", "2", "3"))
x

# or use:
# set_labels(x) <- c("1", "2", "3")

\dontrun{
sjp.frq(x)}
# all three value labels
x <- set_labels(x, c("1", "2", "3"), force.labels = TRUE)
x
\dontrun{
sjp.frq(x)}

# create vector
x <- c(1, 2, 3, 2, 4, NA)
# add less labels than values
x <- set_labels(x, c("yes", "maybe", "no"), force.values = FALSE)
x
# add all necessary labels
x <- set_labels(x, c("yes", "maybe", "no"), force.values = TRUE)
x

# set labels and missings
x <- c(1, 1, 1, 2, 2, -2, 3, 3, 3, 3, 3, 9)
x <- set_labels(x, c("Refused", "One", "Two", "Three", "Missing"))
x

x <- set_na(x, c(-2, 9), as.attr = TRUE)
x
frq(as_labelled(x))


# set labels via named vector,
# not using all possible values
data(efc)
get_labels(efc$e42dep)

x <- set_labels(efc$e42dep, c(`independent` = 1,
                             `severe dependency` = 2,
                             `missing value` = 9))
get_labels(x, include.values = "p")

get_labels(x, include.values = "p", include.non.labelled = TRUE)


# setting same value labels to multiple vectors
# create a set of dummy variables
dummy1 <- sample(1:4, 40, replace = TRUE)
dummy2 <- sample(1:4, 40, replace = TRUE)
dummy3 <- sample(1:4, 40, replace = TRUE)
# put them in list-object
dummies <- list(dummy1, dummy2, dummy3)
# and set same value labels for all three dummies
dummies <- set_labels(dummies, c("very low", "low", "mid", "hi"))
# see result...
get_labels(dummies)

}
\seealso{
See package vignettes or \href{http://www.strengejacke.de/sjPlot/}{online documentation}
           for more details; \code{\link{set_label}} to manually set variable labels or
           \code{\link{get_label}} to get variable labels; \code{\link{add_labels}} to
           add additional value labels without replacing the existing ones.
}

