% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_lvl.R
\name{ref_lvl}
\alias{ref_lvl}
\alias{ref_lvl<-}
\title{Change reference level of (numeric) factors}
\usage{
ref_lvl(x, value = NULL)

ref_lvl(x) <- value
}
\arguments{
\item{x}{\code{\link{factor}} with numeric levels where a new reference
level should be set.}

\item{value}{Numeric, the new reference level.}
}
\value{
\code{x} with new reference level. See 'Details'.
}
\description{
Changes the reference level of numeric factor. See 'Details'.
}
\details{
Unlike \code{\link[stats]{relevel}}, this function a) only accepts
           numeric factors and b) changes the reference level by recoding
           the factor's values using the \code{\link{rec}} function. Hence,
           all values from lowest up to the reference level indicated by
           \code{value} are recoded, with \code{value} starting as lowest
           factor value. See 'Examples'.
}
\examples{
data(efc)
x <- to_factor(efc$e42dep)
str(x)
table(x)

ref_lvl(x) <- 3
str(x)
table(x)

}
\seealso{
\code{\link{to_factor}} to convert numeric vectors into factors;
           \code{\link{rec}} to recode variables.
}

