% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize_lme.R
\name{deff}
\alias{deff}
\title{Design effects for two-level mixed models}
\usage{
deff(n, icc = 0.05)
}
\arguments{
\item{n}{Average number of observations per grouping cluster (i.e. level-2 unit).}

\item{icc}{Assumed intraclass correlation coefficient for multilevel-model.}
}
\value{
The design effect for the two-level model.
}
\description{
Compute the design effect for mixed models with two-level design.
}
\examples{
# Design effect for two-level model with 30 cluster groups
# and an assumed intraclass correlation coefficient of 0.05.
deff(n = 30)

}
\references{
\itemize{
             \item Hsieh FY, Lavori PW, Cohen HJ, Feussner JR. 2003. An Overview of Variance Inflation Factors for Sample-Size Calculation. Evaluation & the Health Professions 26: 239–257. \doi{10.1177/0163278703255230}
             \item Snijders TAB. 2005. Power and Sample Size in Multilevel Linear Models. In: Everitt BS, Howell DC (Hrsg.). Encyclopedia of Statistics in Behavioral Science. Chichester, UK: John Wiley & Sons, Ltd. \doi{10.1002/0470013192.bsa492}
            }
}

