% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight.R
\name{wtd_se}
\alias{wtd_se}
\title{Weighted standard error for variables}
\usage{
wtd_se(x, weights = NULL)
}
\arguments{
\item{x}{(Numeric) vector or a data frame.}

\item{weights}{Numeric vector of weights.}
}
\value{
The weighted standard error of \code{x}, or for each variable
          if \code{x} is a data frame.
}
\description{
Compute weighted standard error for a variable or for all variables
               of a data frame.
}
\examples{
wtd_se(rnorm(n = 100, mean = 3),
       runif(n = 100))

data(efc)
wtd_se(efc[, 1:3], runif(n = nrow(efc)))

}

