% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_all_labels.R
\name{remove_all_labels}
\alias{remove_all_labels}
\title{Remove value and variable labels from vector or data frame}
\usage{
remove_all_labels(x)
}
\arguments{
\item{x}{Vector or \code{data.frame} with variable and/or value label attributes}
}
\value{
\code{x} with removed value and variable label attributes.
}
\description{
This function removes value and variable label attributes
               from a vector or data frame. These attributes are typically
               added to variables when importing foreign data (see
               \code{\link{read_spss}}) or manually adding label attributes
               with \code{\link{set_labels}}.
}
\examples{
data(efc)
str(efc)
str(remove_all_labels(efc))

}
\seealso{
\href{http://www.strengejacke.de/sjPlot/labelleddata/}{sjPlot-manual}
           on working with labelled data, and \code{\link{copy_labels}} for
           adding label attributes (subsetted) data frames.
}

