% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/big_mark.R
\name{big_mark}
\alias{big_mark}
\title{Formats large numbers with big marks}
\usage{
big_mark(x, big.mark = ",", ...)
}
\arguments{
\item{x}{A vector or data frame. All numeric inputs (including numeric character)
vectors) will be prettified.}

\item{big.mark}{Character, used as mark between every 3 decimals before the decimal point.}

\item{...}{Other arguments passed down to the \code{\link{prettyNum}}-function.}
}
\value{
A prettified \code{x} as character, with big marks.
}
\description{
Formats large numbers with big marks
}
\examples{
# simple big mark
big_mark(1234567)

# big marks for several values at once, mixed numeric and character
big_mark(c(1234567, "55443322"))

# pre-defined width of character output
big_mark(c(1234567, 55443322), width = 15)

}
