% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grpmean.R
\name{grpmean}
\alias{grpmean}
\title{Summary of mean values by group}
\usage{
grpmean(x, dv, grp, weights = NULL, digits = 2, out = c("txt",
  "viewer", "browser"), weight.by)
}
\arguments{
\item{x}{A (grouped) data frame.}

\item{dv}{Name of the dependent variable, for which the mean value, grouped
by \code{grp}, is computed.}

\item{grp}{Factor with the cross-classifying variable, where \code{dv} is
grouped into the categories represented by \code{grp}. Numeric vectors
are coerced to factors.}

\item{weights}{Name of variable in \code{x} that indicated the vector of
weights that will be applied to weight all observations. Default is
\code{NULL}, so no weights are used.}

\item{digits}{Numeric, amount of digits after decimal point when rounding
estimates and values.}

\item{out}{Character vector, indicating whether the results should be printed
to console (\code{out = "txt"}) or as HTML-table in the viewer-pane
(\code{out = "viewer"}) or browser (\code{out = "browser"}), of if the
results should be plotted (\code{out = "plot"}, only applies to certain
functions). May be abbreviated.}

\item{weight.by}{Deprecated.}
}
\value{
For non-grouped data frames, \code{grpmean()} returns a data frame with
  following columns: \code{term}, \code{mean}, \code{N}, \code{std.dev},
  \code{std.error} and \code{p.value}. For grouped data frames, returns
  a list of such data frames.
}
\description{
Computes mean, sd and se for each sub-group (indicated by \code{grp})
               of \code{dv}.
}
\details{
This function performs a One-Way-Anova with \code{dv} as dependent
  and \code{grp} as independent variable, by calling
  \code{lm(count ~ as.factor(grp))}. Then \code{\link[emmeans]{contrast}}
  is called to get p-values for each sub-group. P-values indicate whether
  each group-mean is significantly different from the total mean.
}
\examples{
data(efc)
grpmean(efc, c12hour, e42dep)

data(iris)
grpmean(iris, Sepal.Width, Species)

# also works for grouped data frames
library(dplyr)
efc \%>\%
  group_by(c172code) \%>\%
  grpmean(c12hour, e42dep)

# weighting
efc$weight <- abs(rnorm(n = nrow(efc), mean = 1, sd = .5))
grpmean(efc, c12hour, e42dep, weights = weight)

}
