% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{kin2cm}
\alias{kin2cm}
\title{Kinship coefficient to cM}
\usage{
kin2cm(k)
}
\arguments{
\item{k}{Kinship coefficient (numeric, typically between 0 and .5, although KING can produce values <0).}
}
\value{
A vector of numeric estimated cM, ranging from 0-3560.
}
\description{
"Converts" a kinship coefficient to put on the same scale as shared cM using the formula
\eqn{cm <- pmin(3560, 4*pmax(0, k)*3560)}.
}
\examples{
kin2cm(.25)
kin2cm(.125)
kin2cm(.0625)
dibble(9) \%>\% dplyr::mutate(cm=kin2cm(k))

}
\references{
\url{https://dnapainter.com/tools/sharedcmv4}.

\url{https://www.ancestry.com/dna/resource/whitePaper/AncestryDNA-Matching-White-Paper.pdf}.

\url{https://verogen.com/wp-content/uploads/2021/03/snp-typing-uas-kinship-estimation-gedmatch-pro-tech-note-vd2020058-a.pdf}.
}
