% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{T_alpha}
\alias{T_alpha}
\title{Pseudorandom numbers from Asymptotic Null Distribution of Test Statistic for
Method of \insertCite{Rackauskas07;textual}{skedastic}}
\format{
An object of class \code{matrix} (inherits from \code{array}) with 16384 rows and 16 columns.
}
\usage{
T_alpha
}
\description{
A matrix of \eqn{2 ^ 14} rows and 16 columns. Each column contains
\eqn{2 ^ 14} Monte Carlo replicates from the distribution of
\eqn{T_{\alpha}} for a particular value of \eqn{\alpha}, \eqn{\alpha=i/32},
\eqn{i=0,1,\ldots,15}. The values were generated by first generating a
Brownian Bridge using \eqn{m = 2 ^ 17} standard normal variates and then
applying Equation (11) from \insertCite{Rackauskas07;textual}{skedastic}.
It can be used to compute empirical approximate \eqn{p}-values for
implementation of the Rackauskas-Zuokas Test for heteroskedasticity. This
is a time-saving measure because, while \code{\link{rackauskas_zuokas}}
contains an option for simulating the \eqn{p}-value directly, this would be
computationally intensive for the authors' recommended \eqn{m} of
\eqn{2 ^ 17}. Passing the argument \code{pvalmethod = "data"} to
\code{\link{rackauskas_zuokas}} instructs the function to use the
pre-generated values in this data set to compute the empirical approximate
\eqn{p}-value for the test.
}
\keyword{datasets}
