% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-deparse.R
\name{deparse_js}
\alias{deparse_js}
\title{Expression deparsing for JavaScript}
\usage{
deparse_js(ast, deparsers)
}
\arguments{
\item{ast}{language object.}

\item{deparsers}{A list of "typed" deparsers.}
}
\value{
A character string.
}
\description{
This is the "master" deparser that dispatches
the "worker" deparsers based on the type of the input.
}
\examples{
expr_1 <- parse_expr("R.extract(x, 3, )")
deparse_js(expr_1, basic_deparsers())
deparse_js(expr_1, default_deparsers())

expr_2 <- parse_expr("R.data_frame(x = 1, y = 2)")
deparse_js(expr_2, basic_deparsers())
deparse_js(expr_2, default_deparsers())

expr_3 <- parse_expr("lambda(x, x + 1)")
deparse_js(expr_3, basic_deparsers())

}
