% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_users.R
\name{get_users}
\alias{get_users}
\title{Get All Users}
\usage{
get_users(users_desired = 1e+08, api_token)
}
\arguments{
\item{users_desired}{Number of user records to return}

\item{api_token}{Your personalized token provided by 'Skilljar'}
}
\value{
A data frame with users and user data
}
\description{
Returns a data.frame with all users from a particular domain. If you have 
many users and do not want to return them all at once, you may request
fewer users to save time while doing development. The API returns up 10,000
users at a time-- if you request more than 10,000, it will return in full
page increments (a multiple of 10,000).
}
\details{
Utilizing the API requires a token. This must be obtained by logging in
at dashboard.skilljar.com and going to Organization -> API Credentials.
There are different strategies for storing api tokens securely. It is 
an unnecessary risk to store the token in the script!
}
\examples{
\dontrun{
# Retrieve 1000 users
my_users <- get_users(users_desired = 1000,
api_token = "my-token")
}
}
\seealso{
See \url{https://api.skilljar.com/docs/} for documentation on
the 'Skilljar' API.
}
