% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime_wfs_rank.R
\name{modeltime_wfs_rank}
\alias{modeltime_wfs_rank}
\title{Modeltime workflow sets ranking based on a metric}
\usage{
modeltime_wfs_rank(.wfs_results, rank_metric = NULL, minimize = TRUE)
}
\arguments{
\item{.wfs_results}{a tibble generated with the \code{modeltime_wfs_fit()} function.}

\item{rank_metric}{the metric used to generate the ranking 'mae', 'mape','mase','smape','rmse','rsq'.}

\item{minimize}{a boolean indicating whether to minimize (TRUE) or maximize (FALSE) the metric}
}
\value{
a tibble containing the models ranked by a specific metric.
}
\description{
generates a ranking of models generated with \code{modeltime_wfs_fit()} function.
}
\details{
the ranking depends on the metric selected.
}
\examples{
library(dplyr)
library(modeltime)
library(earth)

data <- sknifedatar::data_avellaneda \%>\% 
  mutate(date=as.Date(date)) \%>\% 
  filter(date<'2012-06-01')

recipe_date <- recipes::recipe(value ~ ., data = data) \%>\% 
  recipes::step_date(date, features = c('dow','doy','week','month','year')) 

mars <- parsnip::mars(mode = 'regression') \%>\% parsnip::set_engine('earth')

wfsets <- workflowsets::workflow_set(
  preproc = list(
    R_date = recipe_date),
  models  = list(M_mars = mars),
  cross   = TRUE)

wffits <- sknifedatar::modeltime_wfs_fit(.wfsets = wfsets, 
                                         .split_prop = 0.8, 
                                         .serie = data)

sknifedatar::modeltime_wfs_rank(.wfs_results = wffits,
                                rank_metric = 'rsq',
                                minimize = FALSE)
                                
}
\seealso{
\href{https://rafzamb.github.io/sknifedatar/}{sknifedatar website}
}
