% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_binomial_anticoef.R
\name{gen_binomial_anticoef}
\alias{gen_binomial_anticoef}
\title{Generates Binomial Anticipated Coefficients}
\usage{
gen_binomial_anticoef(anticoef, lowprob, highprob)
}
\arguments{
\item{anticoef}{Anticipated coefficeints}

\item{lowprob}{Default 0.50. The base probability}

\item{highprob}{Default 0.80. The base probability}

\item{runmatrix}{The Run Matrix}

\item{model}{Base model}

\item{contrastslist}{Contrasts}
}
\value{
Anticipated coefficients.
}
\description{
Generates Binomial Anticipated Coefficients
Solves the logistic function
log(p / (1-p)) = beta0 + beta1 * x
such that p = lowprob when x = -1, and p = highprob when x = +1.
Equivalently, solves this set of equations for beta0 and beta1:
log(lowprob / (1 - lowprob)) = beta0 - beta1
log(highprob / (1 - highprob)) = beta0 + beta1
}
\keyword{internal}
