% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertRaw.R
\name{convert_raw}
\alias{convert_raw}
\title{Convert Raw}
\usage{
convert_raw(c, t, path = NULL)
}
\arguments{
\item{c}{Coupon csv file to be processed}

\item{t}{Ticket csv file to be processed}

\item{path}{Path to save file to}
}
\description{
Converts DB1B files from BTS/RITA/Transtats website raw data (prezipped file), for SKYNET's import function.
}
\details{
Coupon files can be found at \url{https://www.transtats.bts.gov/DL_SelectFields.asp?Table_ID=289}.
Ticket files can be found at \url{https://www.transtats.bts.gov/DL_SelectFields.asp?Table_ID=272}.
Both files should belong to the same year and same quarter.
More information on variables to select and type of files to use can be found \href{https://github.com/FilipeamTeixeira/skynet}{here}
}
\examples{
\dontrun{

temp <- tempdir()
convert_raw(skynet_example("Origin_and_Destination_Survey_DB1BCoupon_2001_1.csv"),
skynet_example("Origin_and_Destination_Survey_DB1BTicket_2001_1.csv"),
path = temp)

}

}
