% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mechanics.R
\name{riseset}
\alias{riseset}
\title{Computes the rising and setting azimuth, declination and time of a Solar System object
for a given location and day}
\usage{
riseset(
  obj = "sun",
  date,
  jd,
  alt = 0,
  loc,
  calendar,
  timezone,
  dec,
  refraction,
  atm,
  temp,
  verbose = T
)
}
\arguments{
\item{obj}{(Optional) String containing name of the solar system body of interest. Can be
any of the planets (inc. Pluto), the Moon, the Sun or the Ecliptic. Defaults to 'sun'.}

\item{date}{Either a string containing the date in the format "YYYY/MM/DD"
(see \code{\link{timestring}}), or a numeric containing the julian date (see \code{\link{time2jd}}).
Can also be a single year ("YYYY") or a month ("YYYY/MM") to calculate risings and settings for every day in the
year or month, respectively. Not necessary if \emph{jd} is given.}

\item{jd}{(Optional) A numeric containing the julian date (see \code{\link{time2jd}}) for which to
calculate rising and settings. Only needed if \emph{date} is not given.}

\item{alt}{(Optional) The altitude of the horizon to consider. Defaults to zero degrees.}

\item{loc}{Location, either a \emph{skyscapeR.object} or a vector
containing the latitude, longitude and elevation of location, in this order.}

\item{calendar}{(Optional) Calendar used in parameter \emph{date}. G for gregorian and J for julian.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{timezone}{(Optional) Timezone for output of rising and setting time either as a known acronym
(e.g. "GMT", "CET") or a string with continent followed by country capital (e.g. "Europe/London"). See
\link{timezones} for details. If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{dec}{(Optional) Output declination: \emph{geo} for the geocentric, or \emph{topo} for the topocentric
frame of reference. If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{refraction}{(Optional) Whether atmospheric refraction is to be taken into account.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{atm}{(Optional) Atmospheric pressure for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{temp}{(Optional) Atmospheric temperature for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.#'}

\item{verbose}{(Optional) Boolean to control whether or not to display text. Default is TRUE.}
}
\description{
Computes the rising and setting azimuth, declination and time of a Solar System object
for a given location and day
}
\examples{
# Rising and setting of the sun on june solstice 2018, from the location of London
riseset('sun', '2018/06/21', loc=c(51.5, 0.11, 100))

# Rising ans setting of the moon on june solstice 2018, using a horizon profile
hor <- downloadHWT('HIFVTBGK') # Liverpool cathedral
riseset('moon', '2018/06/21', loc=hor)

# Rising and setting of the sun throughout February 1999, from the location of London
riseset('sun', '1999/02', loc=c(51.5, 0.11, 100))

\dontrun{
# Rising and setting of the sun throughout 3001 BC, from the location of London
riseset('sun', -3000, loc=c(51.5, 0.11, 100))
}
}
\seealso{
\code{\link[swephR]{swe_calc_ut}}, \code{\link[swephR]{swe_azalt}}
}
