% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_table}
\alias{ts_table}
\title{Get the table of individuals/nodes/edges/mutations from the tree sequence}
\usage{
ts_table(ts, table = c("individuals", "edges", "nodes", "mutations"))
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}

\item{table}{Which tree sequence table to return}
}
\value{
Data frame with the information from the give tree-sequence table
(can be either a table of individuals, edges, nodes, or mutations).
}
\description{
This function extracts data from a given tree sequence table. All times are
converted to model-specific time units from tskit's "generations backwards"
time direction.
}
\details{
For further processing and analyses, the output of the function
\code{\link{ts_nodes}} might be more useful, as it merges the information in
node and individual tables into one table and further annotates it with
useful information from the model configuration data.
}
\examples{
# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk and add mutations to it
ts <- ts_load(slendr_ts, model) \%>\% ts_mutate(mutation_rate = 1e-8, random_seed = 42)

# get the 'raw' tskit table of individuals
ts_table(ts, "individuals")

# get the 'raw' tskit table of edges
ts_table(ts, "edges")

# get the 'raw' tskit table of nodes
ts_table(ts, "nodes")

# get the 'raw' tskit table of mutations
ts_table(ts, "mutations")
}
\seealso{
\code{\link{ts_nodes}} and \code{\link{ts_edges}} for accessing an
annotated, more user-friendly and analysis-friendly tree-sequence table
data
}
