% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary-fun.R
\name{Rboot}
\alias{Rboot}
\title{Risk estimation for a tapered covariance matrix estimator via bootstrap method}
\usage{
Rboot(epsilon, treshold, block_size, block_n, model_max, kernel_fonc)
}
\arguments{
\item{epsilon}{an univariate process.}

\item{treshold}{number of estimated autocovariance terms that we consider for the estimation of the covariance matrix.}

\item{block_size}{the size of the bootstrap blocks. \code{block_size} must be greater than \code{model_max}.}

\item{block_n}{blocks number used for the bootstrap.}

\item{model_max}{the maximal dimension, that is the maximal number of terms available to estimate the covariance matrix.}

\item{kernel_fonc}{the kernel to use. The user can define his own kernel and put it in the argument.}
}
\value{
This function returns a list with:
 \item{risk}{for one treshold, the value of the estimated risk.}
 \item{SE}{the standard-error due to the bootstrap.}
}
\description{
This function computes an estimation of the risk for the tapered covariance matrix estimator of a process via a bootstrap method,
 for a specified treshold and a specified kernel.
}
\references{
E. Caron, J. Dedecker and B. Michel (2019). Linear regression with stationary errors: the R package slm. \emph{arXiv preprint arXiv:1906.06583}.
 \url{https://arxiv.org/abs/1906.06583}.
}
