% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.slouch}
\alias{print.slouch}
\title{Print, minimalist output}
\usage{
\method{print}{slouch}(x, ...)
}
\arguments{
\item{x}{An object of class 'slouch'}

\item{...}{additional parameters}
}
\description{
Print, minimalist output
}
\examples{
data(artiodactyla)
data(neocortex)

neocortex <- neocortex[match(artiodactyla$tip.label, neocortex$species), ]

m0 <- slouch.fit(phy = artiodactyla,
                 hl_values = seq(0.001, 4, length.out = 15),
                 vy_values = seq(0.001, 0.05, length.out = 15),
                 species = neocortex$species,
                 response = neocortex$neocortex_area_mm2_log_mean,
                 mv.response = neocortex$neocortex_se_squared,
                 random.cov = neocortex$brain_mass_g_log_mean,
                 mv.random.cov = neocortex$brain_se_squared,
                 fixed.fact = neocortex$diet)
}
