% Generated by roxygen2 (4.0.2): do not edit by hand
\name{spscan.test}
\alias{spscan.test}
\title{Spatial Scan Test}
\usage{
spscan.test(x, nsim = 499, case = 2, len = 50, nreport = nsim + 1,
  maxr = NULL)
}
\arguments{
\item{x}{A \code{ppp} object from the \code{spatstat} package with marks for the case and control groups.}

\item{nsim}{The number of simulations from which to compute p-value.}

\item{case}{The position of the name of the "case" group in levels(x$marks).  The default is 2.}

\item{len}{The length of the vector of radii from which to perform the test.}

\item{nreport}{The frequency with which to report simulation progress.  The default is \code{nsim+ 1}, meaning no progress will be displayed.}

\item{maxr}{The max distance of the vector of radii from which to perform the test.}
}
\value{
Returns a list with the following components:
\item{pvalue}{The p-value of the spatial scan test.}
\item{mlc}{The location of the most likely cluster.}
\item{r}{The radius of the window of the most likely cluster.}
}
\description{
\code{spscan.test} performs the spatial scan test of Kulldorf (1997).
}
\details{
The test is performed using the random labeling hypothesis.  The windows are circular and extend from the observed data locations.  The minimum window radius is the minimum distance between cases.  The default upper bound is half the maximum interevent distance.
}
\examples{
data(grave)
out = spscan.test(grave)
plot(grave)
# draw location of most likely cluster
# uses function from plotrix package
library(plotrix)
draw.circle(out$mlc[1], out$mlc[2], out$r)
}
\author{
Joshua French
}
\references{
Waller, L.A. and Gotway, C.A. (2005).  Applied Spatial Statistics for Public Health Data.  Hoboken, NJ: Wiley.  Kulldorff, M. (1997) A spatial scan statistic. Communications in Statistics -- Theory and Methods 26, 1481-1496.
}

