% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.logrrenv.R
\name{plot.logrrenv}
\alias{plot.logrrenv}
\title{Plots object from logrr of class \code{logrrenv}.}
\usage{
\method{plot}{logrrenv}(x, ..., conlist = list())
}
\arguments{
\item{x}{An object of class logrrenv to be plotted.}

\item{...}{Additional graphical parameters passed to the \code{spatstat::image.im} function.  See details.}

\item{conlist}{Additional argument passed to the \code{spatstat::contour.im} function.}
}
\description{
Plots object from logrr of class \code{logrrenv}.
}
\details{
An important aspect of this plot is the color argument (\code{col}) used for displaying the regions outside the tolerance envelopes.  If NULL (the implicit default), then the default color palette used by \code{image.im} will be used.  Simpler schemes, e.g., c("blue", "white", "orange") can suffice. See the examples.
}
\examples{
data(grave)
rsim = logrr(grave, nsim = 9)
plot(rsim)
# no border or ribben (legend).  Simple color scheme.
plot(rsim, col = c("blue", "white", "orange"), ribbon = FALSE, box = FALSE)
# alternate color scheme
plot(rsim, col = topo.colors(12))
}

