% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tolenv.R
\name{tolenv}
\alias{tolenv}
\title{Tolerance envelopes for log ratio of spatial densities.}
\usage{
tolenv(object, level = 0.9, alternative = "two.sided")
}
\arguments{
\item{object}{An \code{im} object from the \code{logrr} function.}

\item{level}{Confidence level.  Should be a number between 0 and 1.  Default is 0.95.}

\item{alternative}{Default is "two.sided".  Can also be "greater" or "lower".}
}
\value{
Returns an \code{tolenv} object.  This is just a list with components \code{x}, \code{y}, and \code{z} the can be used with the \code{image} or \code{contour} functions quite easily.
}
\description{
\code{tolenv} determines tolerance envelopes for the log ratio of spatial densities of cases and controls.  Specifically, the function identifies where the observed log ratio of spatial densities exceeds what is expected under the random labeling hypothesis.  Results can be easily plotted using the contour or image functions.
}
\details{
\code{alternative ="two.sided"} identifies locations where the observed log ratio of spatial densities is below and above, respectively, the (1-level)/2 and 1 - (1-level)/2 quantiles of log ratios of spatial densities simulated under the random labeling hypothesis.  "greater" finds where the observed ratio exceeds the "level" quantile.  "lower" finds where the observed ratio exceeds the 1 - level quantile.

The \code{z} argument of the list returned has a -1 for locations where the observed log ratio of spatial densities is below the tolerance envelope, a 0 for locations within the tolerance envelope, and a 1 for locations where the log ratio of spatial densities exceeds the tolerance envelope.
}
\author{
Joshua French
}
\references{
Waller, L.A. and Gotway, C.A. (2005).  Applied Spatial Statistics for Public Health Data.  Hoboken, NJ: Wiley.
}

