% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets_spacing.R
\name{sets_spacing}
\alias{sets_spacing}
\title{Sets spacing}
\usage{
sets_spacing(
  captions = NULL,
  degree = NULL,
  header = NULL,
  right = NULL,
  rows = NULL
)
}
\arguments{
\item{captions}{Positive numeric value for amount of caption space below
snapshots.}

\item{degree}{Integer between 0-90 (degrees) to rotate column names.}

\item{header}{Positive numeric value for amount of column name space.}

\item{right}{Positive numeric value (>=.5) for amount of space to the right
of each snapshot.}

\item{rows}{Integer for number of Timeline rows.}
}
\value{
Returns a list with five elements (the spacing parameters).
}
\description{
Sets spacing parameters for the Smallset Timeline.
}
\details{
Passed to \code{spacing} in \link{Smallset_Timeline}.
}
\examples{
# increase space for captions and rotate column names
Smallset_Timeline(
   data = s_data,
   code = system.file("s_data_preprocess.R", package = "smallsets"),
   spacing = sets_spacing(captions = 5, degree = 45)
)

}
