% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.metrics}
\alias{smbinning.metrics}
\title{Performance Metrics for a Classification Model}
\usage{
smbinning.metrics(dataset, prediction, actualclass, cutoff = NA,
  report = 1, plot = "none", returndf = 0)
}
\arguments{
\item{dataset}{Data frame.}

\item{prediction}{Classifier. A value generated by a classification model (Must be numeric).}

\item{actualclass}{Binary variable (0/1) that represents the actual class (Must be numeric).}

\item{cutoff}{Point at wich the classifier splits (predicts) the actual class (Must be numeric). 
If not specified, it will be estimated by using the maximum value of Youden J (Sensitivity+Specificity-1).
If not found in the data frame, it will take the closest lower value.}

\item{report}{Indicator defined by user. 1: Show report (Default), 0: Do not show report.}

\item{plot}{Specifies the plot to be shown for overall evaluation. It has three options: 'auc' shows the ROC curve, 
'ks' shows the cumulative distribution of the actual class and its maximum difference (KS Statistic), and 'none' (Default).}

\item{returndf}{Option for the user to save the data frame behind the metrics. 1: Show data frame, 0: Do not show (Default).}
}
\value{
The command \code{smbinning.metrics} returns a report with classic performance metrics of a classification model.
}
\description{
It computes the classic performance metrics of a scoring model, including AUC, KS and all the relevant ones
from the classification matrix at a specific threshold or cutoff.
}
\examples{
# Load library and its dataset
library(smbinning) # Load package and its data

# Example: Metrics Credit Score 1
smbinning.metrics(dataset=chileancredit,prediction="cbs1",actualclass="fgood",
                  report=1) # Show report
smbinning.metrics(dataset=chileancredit,prediction="cbs1",actualclass="fgood",
                  cutoff=600, report=1) # User cutoff
smbinning.metrics(dataset=chileancredit,prediction="cbs1",actualclass="fgood",
                  report=0, plot="auc") # Plot AUC
smbinning.metrics(dataset=chileancredit,prediction="cbs1",actualclass="fgood",
                  report=0, plot="ks") # Plot KS

# Save table with all details of metrics
cbs1metrics=smbinning.metrics(
  dataset=chileancredit,prediction="cbs1",actualclass="fgood",
  report=0, returndf=1) # Save metrics details
}
