% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smdi_asmd.R
\name{smdi_asmd}
\alias{smdi_asmd}
\title{Computes mean/median absolute standardized mean differences between observed and missing observations}
\usage{
smdi_asmd(
  data = NULL,
  covar = NULL,
  median = TRUE,
  includeNA = FALSE,
  n_cores = 1
)
}
\arguments{
\item{data}{dataframe or tibble object with partially observed/missing variables}

\item{covar}{character covariate or covariate vector with partially observed variable/column name(s) to investigate. If NULL, the function automatically includes all columns with at least one missing observation and all remaining covariates will be used as predictors}

\item{median}{logical if the median (= TRUE; recommended default) or mean of all absolute standardized mean differences (asmd) should be computed}

\item{includeNA}{logical, should missingness of other partially observed covariates be explicitly modeled (default is FALSE)}

\item{n_cores}{integer, if >1, computations will be parallelized across amount of cores specified in n_cores (only UNIX systems)}
}
\value{
returns an asmd object with average/median absolute standardized mean differences. That is, for each covar, the following outputs are provided:
\itemize{
\item asmd_covar: name of covariate investigated
\item asmd_table1: detailed "table 1" illustrating distributions and differences of patient characteristics between those without (1) and with (0) observed covariate
\item asmd_plot: plot of absolute standardized mean differences (asmd) between patients without (1) and with (0) observed covariate (sorted by asmd)
\item asmd_aggregate: average/median absolute standardized mean difference (and min, max) of patient characteristics between those without (1) and with (0) observed covariate
}
}
\description{
This function takes a dataframe with covariates which are partially observed/missing and returns the
median/average absolute standardized mean difference (asmd) and more details for every specified covariate in covar
(if NULL all covariates with at least one NA are considered).

Important: don't include variables like ID variables, ZIP codes, dates, etc.
}
\details{
The asmd may be one indicator as to how much patient characteristics differ between patients with and without an observed
value for a partially observed covariate. If the median/average asmd is above a certain threshold this may indicate
imbalance in patient covariate distributions which may be indicative of the partially observed covariate following a
missing at random (MAR) mechanims, i.e. the missingness is explainable by other observed covariates. Similarly,
no imbalance between observed covariates may be indicative that missingness cannot be explained with observed
covariates and the underlying missingness mechanism may be completely at random (MCAR) or not at random (e.g.
missingness is only associated with unobserved factors or through the partially observed covariate itself).

A clear cut-off is hard to determine and analogues to propensity scores,
some researchers have proposed that a standardized difference of 0.1 (10 per cent)
denotes meaningful imbalance in the baseline covariate.

The asmd is computed for every covariate one-by-one and not jointly. If there is multivariate
missingness, i.e. more than just one missing covariate exists, you can decide what should
happen with the other partially observed 'predictor' covariates using the includeNA parameter.
That is, if includeNA is set to FALSE (default), only the asmd between observed cases will be computed,
and if includeNA is set to TRUE, missingness is modeled as an explicit category (categorical covariates only).

If any other behavior is desired, data transformations for example with the \code{\link{smdi_na_indicator}} function, may make sense
before calling the function.

The dataframe should generally consist of the exposure variable, the outcome variable(s), the partially observed covariates
and all other fully observed covariates which are deemed important for the final modeling
and (optionally) which could be considered as auxiliary variables. If no partially observed covariates are provided,
the function automatically looks for all variables/columns with NA (powered by the \code{\link{smdi_summarize}} function)
}
\examples{
library(smdi)
library(dplyr)

# S3 print method
asmd <- smdi_asmd(data = smdi_data)
asmd

# let's look at the first variable
# we can check the complete covariate distribution
asmd$pdl1_num$asmd_table1

}
\references{
Austin PC. Balance diagnostics for comparing the distribution of baseline covariates between treatment groups in propensity-score matched samples. Stat Med. 2009 Nov 10;28(25):3083-107.

Normand SLT, Landrum MB, Guadagnoli E, Ayanian JZ, Ryan TJ, Cleary PD, McNeil BJ. Validating recommendations for coronary angiography following an acute myocardial infarction in the elderly: a matched analysis using propensity scores. Journal of Clinical Epidemiology. 2001;54:387–398.
}
\seealso{
\code{\link[tableone]{CreateTableOne}}
}
