% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smdi_na_indicator.R
\name{smdi_na_indicator}
\alias{smdi_na_indicator}
\title{Create binary missing indicator variables by two different strategies}
\usage{
smdi_na_indicator(data = NULL, covar = NULL, drop_NA_col = TRUE)
}
\arguments{
\item{data}{dataframe or tibble object with partially observed/missing variables}

\item{covar}{character covariate or covariate vector with partially observed variable/column name(s) to investigate. If NULL, the function automatically includes all columns with at least one missing observation.}

\item{drop_NA_col}{logical, drop specified columns with NA (default) or retain those columns}
}
\value{
returns the dataframe with missing indicator variables (column names are ending on "_NA")
}
\description{
This function takes a dataframe and creates binary missing indicator variable. This can be realized with two
different approaches:

Approach 1 (drop_NA_col = FALSE): creates a binary missing indicator variable for partially observed variables and retains both original and indicator variables.

Approach 2 (drop_NA_col = TRUE): creates a binary missing indicator variable for partially observed variables and only retains indicator variables (and drops the original variables).

Important: Make sure you have your variables format correct and avoid to include variables like ID variables, ZIP codes, dates, etc.
}
\examples{
library(smdi)
library(dplyr)

smdi_data \%>\%
  smdi_na_indicator(drop_NA_col = FALSE) \%>\%
  glimpse()

smdi_data \%>\%
  smdi_na_indicator(drop_NA_col = TRUE) \%>\%
  glimpse()

}
