% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precog.test.R
\name{precog.test}
\alias{precog.test}
\title{PreCoG Scan Test}
\usage{
precog.test(
  coords,
  cases,
  pop,
  w,
  ex = sum(cases)/sum(pop) * pop,
  nsim = 499,
  tol_prob = 0.9,
  alpha = 0.1,
  ubpop = 0.5,
  longlat = FALSE,
  cl = NULL,
  ysim = NULL
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{nsim}{The number of simulations from which to
compute the p-value.}

\item{tol_prob}{A single numeric value between 0 and 1
that describes the quantile of the tolerance envelopes
used to prefilter regions from the candidate zones.}

\item{alpha}{The significance level to determine whether
a cluster is signficant.  Default is 0.10.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
It can also be \code{"future"} to use a future backend (see Details),
\code{NULL} (default) refers to sequential evaluation.
}

\item{ysim}{A matrix of size \code{nsim}\eqn{\times n},
where \eqn{n} is the number of regions in the study
area. This is a matrix of \code{nsim} realizations of
the case counts for each region in the study area under
the null hypothesis. This argument is only not meant to
be used by the user.}
}
\value{
Returns a \code{smerc_cluster} object.
}
\description{
\code{precog.test} is an implementation of the
Prefiltered Component-based Greedy Scan Method.
}
\examples{
data(nydf)
data(nyw)
out <- precog.test(coords = nydf[,c("x", "y")],
                   cases = floor(nydf$cases),
                   pop = nydf$pop, w = nyw, nsim = 19,
                   alpha = 0.2)
# better plotting
if (require("sf", quietly = TRUE)) {
   data(nysf)
   plot(st_geometry(nysf), col = color.clusters(out))
}
}
\seealso{
\code{\link{print.smerc_cluster}},
  \code{\link{summary.smerc_cluster}},
  \code{\link{plot.smerc_cluster}},
}
\author{
Joshua French and Mohammad Meysami
}
