% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mof.dtlz4.R
\name{makeDTLZ4Function}
\alias{makeDTLZ4Function}
\title{DTLZ4 Function (family)}
\usage{
makeDTLZ4Function(dimensions, n.objectives, alpha = 100)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Number of decision variables.}

\item{n.objectives}{[\code{integer(1)}]\cr
Number of objectives.}

\item{alpha}{[\code{numeric(1)}]\cr
Optional parameter. Default is 100, which is recommended by Deb et al.}
}
\value{
[\code{smoof_multi_objective_function}]
}
\description{
Builds and returns the multi-objective DTLZ4 test problem. It is a slight
modification of the DTLZ2 problems by introducing the parameter \eqn{\alpha}.
The parameter is used to map \eqn{\mathbf{x}_i \rightarrow \mathbf{x}_i^{\alpha}}.
}
\details{
The DTLZ4 test problem is defined as follows:

Minimize \eqn{f_1(\mathbf{x}) = (1+g(\mathbf{x}_M)) \cos(x_1^\alpha\pi/2) \cos(x_2^\alpha\pi/2) \cdots \cos(x_{M-2}^\alpha\pi/2) \cos(x_{M-1}^\alpha\pi/2),}{
f[1](X) = (1 + g(XM)) * cos(x[1]^alpha * pi/2) * cos(x[2]^alpha * pi/2) * ... * cos(x[M-2]^alpha * pi/2) * cos(x[M-1]^alpha * pi/2)}

Minimize \eqn{f_2(\mathbf{x}) = (1+g(\mathbf{x}_M)) \cos(x_1^\alpha\pi/2) \cos(x_2^\alpha\pi/2) \cdots \cos(x_{M-2}^\alpha\pi/2) \sin(x_{M-1}^\alpha\pi/2),}{
f[2](X) = (1 + g(XM)) * cos(x[1]^alpha * pi/2) * cos(x[2]^alpha * pi/2) * ... * cos(x[M-2]^alpha * pi/2) * sin(x[M-1]^alpha * pi/2)}

Minimize \eqn{f_3(\mathbf{x}) = (1+g(\mathbf{x}_M)) \cos(x_1^\alpha\pi/2) \cos(x_2^\alpha\pi/2) \cdots \sin(x_{M-2}^\alpha\pi/2),}{
f[3](X) = (1 + g(XM)) * cos(x[1]^alpha * pi/2) * cos(x[2]^alpha * pi/2) * ... * sin(x[M-2]^alpha * pi/2)}

\eqn{\vdots\\}{...}

Minimize \eqn{f_{M-1}(\mathbf{x}) = (1+g(\mathbf{x}_M)) \cos(x_1^\alpha\pi/2) \sin(x_2^\alpha\pi/2),}{
f[M-1](X) = (1 + g(XM)) * cos(x[1]^alpha * pi/2) * sin(x[2]^alpha * pi/2)}

Minimize \eqn{f_{M}(\mathbf{x}) = (1+g(\mathbf{x}_M)) \sin(x_1^\alpha\pi/2),}{
f[M](X) = (1 + g(XM)) * sin(x[1]^alpha * pi/2)}

with \eqn{0 \leq x_i \leq 1}{0 <= x[i] <= 1}, for \eqn{i=1,2,\dots,n,}{i=1,2,...,n}

where \eqn{g(\mathbf{x}_M) = \sum\limits_{x_i\in \mathbf{x}_M}(x_i-0.5)^2}{
g(XM) = sum{x[i] in XM} {(x[i] - 0.5)^2}}
}
\references{
K. Deb and L. Thiele and M. Laumanns and E. Zitzler. Scalable
Multi-Objective Optimization Test Problems. Computer Engineering and Networks
Laboratory (TIK), Swiss Federal Institute of Technology (ETH) Zurich, 112, 2001
}

