% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sof.modrastrigin.R
\name{makeModifiedRastriginFunction}
\alias{makeModifiedRastriginFunction}
\title{Rastrigin Function}
\usage{
makeModifiedRastriginFunction(dimensions, k = rep(1, dimensions))
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Size of corresponding parameter space.}

\item{k}{[numeric]\cr
Vector of numerical values of length \code{dimensions}.
Default is \code{rep(1, dimensions)}}
}
\value{
[\code{smoof_single_objective_function}]
}
\description{
A modified version of the Rastrigin function following the formula:
\deqn{f(\mathbf{x}) = \sum_{i=1}^{n} 10\left(1 + \cos(2\pi k_i \mathbf{x}_i)\right) + 2 k_i \mathbf{x}_i^2.}
The box-constraints are given by \eqn{\mathbf{x}_i \in [0, 1]} for
\eqn{i = 1, \ldots, n} and \eqn{k} is a numerical vector. Deb et al. (see references)
use, e.g., \eqn{k = (2, 2, 3, 4)} for \eqn{n = 4}. See the reference for details.
}
\references{
Kalyanmoy Deb and Amit Saha. Multimodal optimization using a bi-
objective evolutionary algorithm. Evolutionary Computation, 20(1):27-62, 2012.
}
