% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFunctionsByName.R
\name{makeFunctionsByName}
\alias{makeFunctionsByName}
\title{Generate smoof function by passing a character vector of generator
names.}
\usage{
makeFunctionsByName(fun.names, ...)
}
\arguments{
\item{fun.names}{[\code{character}]\cr
Non empty character vector of generator function names.}

\item{...}{[any]\cr
Further arguments passed to generator.}
}
\value{
[\code{smoof_function}]
}
\description{
This function is especially useful in combination with
\code{\link{filterFunctionsByTags}} to generate a test set of functions
with certain properties, e.~g., multimodality.
}
\examples{
# generate a testset of multimodal 2D functions
\dontrun{
test.set = makeFunctionsByName(filterFunctionsByTags("multimodal"), dimensions = 2L, m = 5L)
}
}
\seealso{
\code{\link{filterFunctionsByTags}}
}
