% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adam.R, R/methods.R, R/msdecompose.R
\name{plot.adam}
\alias{plot.adam}
\alias{plot.smooth}
\alias{plot.msdecompose}
\title{Plots for the fit and states}
\usage{
\method{plot}{adam}(x, which = c(1, 2, 4, 6), level = 0.95,
  legend = FALSE, ask = prod(par("mfcol")) < length(which) &&
  dev.interactive(), lowess = TRUE, ...)

\method{plot}{smooth}(x, which = c(1, 2, 4, 6), level = 0.95,
  legend = FALSE, ask = prod(par("mfcol")) < length(which) &&
  dev.interactive(), lowess = TRUE, ...)

\method{plot}{msdecompose}(x, which = c(1, 2, 4, 6), level = 0.95,
  legend = FALSE, ask = prod(par("mfcol")) < length(which) &&
  dev.interactive(), lowess = TRUE, ...)
}
\arguments{
\item{x}{Estimated smooth model.}

\item{which}{Which of the plots to produce. The possible options (see details for explanations):
\enumerate{
\item Actuals vs Fitted values;
\item Standardised residuals vs Fitted;
\item Studentised residuals vs Fitted;
\item Absolute residuals vs Fitted;
\item Squared residuals vs Fitted;
\item Q-Q plot with the specified distribution;
\item Fitted over time;
\item Standardised residuals vs Time;
\item Studentised residuals vs Time;
\item ACF of the residuals;
\item PACF of the residuals;
\item Plot of states of the model;
\item Absolute standardised residuals vs Fitted;
\item Squared standardised residuals vs Fitted;
\item ACF of the squared residuals;
\item PACF of the squared residuals.
}}

\item{level}{Confidence level. Defines width of confidence interval. Used in plots (2), (3), (7), (8),
(9), (10) and (11).}

\item{legend}{If \code{TRUE}, then the legend is produced on plots (2), (3) and (7).}

\item{ask}{Logical; if \code{TRUE}, the user is asked to press Enter before each plot.}

\item{lowess}{Logical; if \code{TRUE}, LOWESS lines are drawn on scatterplots, see \link[stats]{lowess}.}

\item{...}{The parameters passed to the plot functions. Recommended to use with separate plots.}
}
\value{
The function produces the number of plots, specified in the parameter \code{which}.
}
\description{
The function produces diagnostics plots for a \code{smooth} model
}
\details{
The list of produced plots includes:
\enumerate{
\item Actuals vs Fitted values. Allows analysing, whether there are any issues in the fit.
Does the variability of actuals increase with the increase of fitted values? Is the relation
well captured? They grey line on the plot corresponds to the perfect fit of the model.
\item Standardised residuals vs Fitted. Plots the points and the confidence bounds
(red lines) for the specified confidence \code{level}. Useful for the analysis of outliers;
\item Studentised residuals vs Fitted. This is similar to the previous plot, but with the
residuals divided by the scales with the leave-one-out approach. Should be more sensitive
to outliers;
\item Absolute residuals vs Fitted. Useful for the analysis of heteroscedasticity;
\item Squared residuals vs Fitted - similar to (3), but with squared values;
\item Q-Q plot with the specified distribution. Can be used in order to see if the
residuals follow the assumed distribution. The type of distribution depends on the one used
in the estimation (see \code{distribution} parameter in \link[greybox]{alm});
\item ACF of the residuals. Are the residuals autocorrelated? See \link[stats]{acf} for
details;
\item Fitted over time. Plots actuals (black line), fitted values (purple line), point forecast
(blue line) and prediction interval (grey lines). Can be used in order to make sure that the model
did not miss any important events over time;
\item Standardised residuals vs Time. Useful if you want to see, if there is autocorrelation or
if there is heteroscedasticity in time. This also shows, when the outliers happen;
\item Studentised residuals vs Time. Similar to previous, but with studentised residuals;
\item PACF of the residuals. No, really, are they autocorrelated? See pacf function from stats
package for details;
\item Plot of the states of the model. It is not recommended to produce this plot together with
the others, because there might be several states, which would cause the creation of a different
canvas. In case of "msdecompose", this will produce the decomposition of the series into states
on a different canvas;
\item Absolute standardised residuals vs Fitted. Similar to the previous, but with absolute
values. This is more relevant to the models where scale is calculated as an absolute value of
something (e.g. Laplace);
\item Squared standardised residuals vs Fitted. This is an additional plot needed to diagnose
heteroscedasticity in a model with varying scale. The variance on this plot will be constant if
the adequate model for \code{scale} was constructed. This is more appropriate for normal and
the related distributions.
}
Which of the plots to produce, is specified via the \code{which} parameter.
}
\examples{

ourModel <- es(c(rnorm(50,100,10),rnorm(50,120,10)), "ANN", h=10)
par(mfcol=c(3,4))
plot(ourModel, c(1:11))
plot(ourModel, 12)

}
\seealso{
\link[greybox]{plot.greybox}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{ts}
\keyword{univar}
