% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothedLasso.r
\name{solveUnsmoothedLASSO}
\alias{solveUnsmoothedLASSO}
\title{Minimize the unsmoothed LASSO objective function with respect to \eqn{\beta}.
Three options are available: BFGS with analytical gradient (\eqn{method=0}), BFGS with numerical gradient (\eqn{method=1}), and simulated annealing which is gradient free (\eqn{method=2}).
The default is \eqn{method=0}.}
\usage{
solveUnsmoothedLASSO(X, y, lambda, method = 0)
}
\arguments{
\item{X}{The data matrix of dimensions \eqn{n \times p}.}

\item{y}{The \eqn{n}-vector of responses.}

\item{lambda}{The LASSO regularization parameter.}

\item{method}{The method used for minimization: BFGS with analytical gradient (\eqn{method=0}), BFGS with numerical gradient (\eqn{method=1}), and simulated annealing which is gradient free (\eqn{method=2}). The default is \eqn{method=0}.}
}
\value{
The LASSO estimator \eqn{\beta}.
}
\description{
Minimize the unsmoothed LASSO objective function with respect to \eqn{\beta}.
Three options are available: BFGS with analytical gradient (\eqn{method=0}), BFGS with numerical gradient (\eqn{method=1}), and simulated annealing which is gradient free (\eqn{method=2}).
The default is \eqn{method=0}.
}
\examples{
library(smoothedLasso)
n <- 100
p <- 500
beta <- runif(p)
X <- matrix(runif(n*p),nrow=n,ncol=p)
y <- X \%*\% beta
lambda <- 1
print(solveUnsmoothedLASSO(X,y,lambda))

}
